<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Register Video Gallery Custom Post Type and Taxonomy
 */
function mohtavanegar_register_video_gallery_post_type() {
    $labels = array(
        'name'                  => _x('گالری ویدئو', 'Post type general name', 'mohtavanegar'),
        'singular_name'         => _x('ویدئو', 'Post type singular name', 'mohtavanegar'),
        'menu_name'            => _x('گالری ویدئو', 'Admin Menu text', 'mohtavanegar'),
        'name_admin_bar'       => _x('ویدئو', 'Add New on Toolbar', 'mohtavanegar'),
        'add_new'              => __('افزودن جدید', 'mohtavanegar'),
        'add_new_item'         => __('افزودن ویدئو جدید', 'mohtavanegar'),
        'new_item'             => __('ویدئو جدید', 'mohtavanegar'),
        'edit_item'            => __('ویرایش ویدئو', 'mohtavanegar'),
        'view_item'            => __('مشاهده ویدئو', 'mohtavanegar'),
        'all_items'            => __('همه ویدئو ها', 'mohtavanegar'),
        'search_items'         => __('جستجوی ویدئو', 'mohtavanegar'),
        'not_found'            => __('هیچ ویدئویی یافت نشد.', 'mohtavanegar'),
        'not_found_in_trash'   => __('هیچ ویدئویی در سطل زباله یافت نشد.', 'mohtavanegar'),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'video-gallery'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 6,
        'menu_icon'          => 'dashicons-video-alt3',
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt'),
        'show_in_rest'       => true,
    );

    register_post_type('video_gallery', $args);

    // Register Taxonomy
    $tax_labels = array(
        'name'              => _x('دسته‌بندی ویدئوها', 'taxonomy general name', 'mohtavanegar'),
        'singular_name'     => _x('دسته‌بندی ویدئو', 'taxonomy singular name', 'mohtavanegar'),
        'search_items'      => __('جستجوی دسته‌بندی‌ها', 'mohtavanegar'),
        'all_items'         => __('همه دسته‌بندی‌ها', 'mohtavanegar'),
        'parent_item'       => __('دسته‌بندی والد', 'mohtavanegar'),
        'parent_item_colon' => __('دسته‌بندی والد:', 'mohtavanegar'),
        'edit_item'         => __('ویرایش دسته‌بندی', 'mohtavanegar'),
        'update_item'       => __('بروزرسانی دسته‌بندی', 'mohtavanegar'),
        'add_new_item'      => __('افزودن دسته‌بندی جدید', 'mohtavanegar'),
        'new_item_name'     => __('نام دسته‌بندی جدید', 'mohtavanegar'),
        'menu_name'         => __('دسته‌بندی‌ها', 'mohtavanegar'),
    );

    $tax_args = array(
        'hierarchical'      => true,
        'labels'            => $tax_labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'video-category'),
        'show_in_rest'      => true,
    );

    register_taxonomy('video_category', array('video_gallery'), $tax_args);
}
add_action('init', 'mohtavanegar_register_video_gallery_post_type');

/**
 * Add Meta Box for Video Upload
 */
function mohtavanegar_add_video_meta_boxes() {
    add_meta_box(
        'video_details',
        __('تنظیمات ویدئو', 'mohtavanegar'),
        'mohtavanegar_video_meta_box_callback',
        'video_gallery',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'mohtavanegar_add_video_meta_boxes');

function mohtavanegar_video_meta_box_callback($post) {
    wp_nonce_field('mohtavanegar_save_video_meta', 'mohtavanegar_video_meta_nonce');

    $video_url = get_post_meta($post->ID, '_video_url', true);
    ?>
    <div class="mohtavanegar-meta-box">
        <p>
            <label for="video_url"><?php _e('فایل ویدئو:', 'mohtavanegar'); ?></label>
            <div style="display:flex; gap:10px; margin-top:5px;">
                <input type="text" id="video_url" name="video_url" value="<?php echo esc_attr($video_url); ?>" class="widefat" placeholder="URL ویدئو یا آپلود کنید">
                <button type="button" id="upload_video_btn" class="button button-secondary"><?php _e('انتخاب/آپلود ویدئو', 'mohtavanegar'); ?></button>
            </div>
        </p>
        <div id="video_preview_wrapper" style="margin-top: 15px; <?php echo empty($video_url) ? 'display:none;' : ''; ?>">
            <video id="video_capture_player" controls style="max-width: 100%; border-radius: 8px;">
                <source src="<?php echo esc_url($video_url); ?>" type="video/mp4">
            </video>
            <p>
                <button type="button" id="capture_frame_btn" class="button button-primary"><?php _e('انتخاب این فریم به عنوان تصویر شاخص', 'mohtavanegar'); ?></button>
                <label style="margin-right:15px; vertical-align:middle; cursor:pointer;">
                    <input type="checkbox" id="add_title_to_image" style="margin-top:0;"> <?php _e('درج عنوان روی تصویر', 'mohtavanegar'); ?>
                </label>
                <span id="capture_status" style="margin-right:10px;"></span>
            </p>

            <div id="title_settings_wrapper" style="display:none; background: #f9f9f9; padding: 20px; border-radius: 8px; margin-top: 15px; border: 1px solid #e0e0e0; box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);">
                <h4 style="margin-top:0; border-bottom:1px solid #ddd; padding-bottom:10px;"><?php _e('تنظیمات درج عنوان', 'mohtavanegar'); ?></h4>
                
                <div style="margin-bottom: 20px;">
                    <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('متن عنوان (Enter برای خط جدید):', 'mohtavanegar'); ?></label>
                    <textarea id="custom_title_text" style="width:100%; height:80px; border-radius:4px; border:1px solid #ccc; padding:10px; font-family:Vazirmatn, Tahoma;"></textarea>
                </div>

                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px;">
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('رنگ متن:', 'mohtavanegar'); ?></label>
                        <input type="color" id="title_color" value="#ffffff" style="width:100%; height:35px; border-radius:4px; border:1px solid #ccc;">
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('فونت:', 'mohtavanegar'); ?></label>
                        <select id="title_font_family" style="width:100%; height:35px;">
                            <option value="Vazirmatn, Vazir, Tahoma">وزیر (پیش‌فرض)</option>
                            <option value="Tahoma, Arial">Tahoma</option>
                            <option value="Arial, sans-serif">Arial</option>
                            <option value="cursive">Cursive</option>
                        </select>
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('تراز بندی افقی:', 'mohtavanegar'); ?></label>
                        <select id="title_align_h" style="width:100%; height:35px;">
                            <option value="center"><?php _e('وسط', 'mohtavanegar'); ?></option>
                            <option value="right"><?php _e('راست', 'mohtavanegar'); ?></option>
                            <option value="left"><?php _e('چپ', 'mohtavanegar'); ?></option>
                        </select>
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('سایز فونت (پیکسل):', 'mohtavanegar'); ?></label>
                        <input type="number" id="title_font_size" value="40" min="10" max="200" style="width:100%; height:35px;">
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('موقعیت عمودی:', 'mohtavanegar'); ?></label>
                        <select id="title_align_v" style="width:100%; height:35px;">
                            <option value="middle"><?php _e('وسط', 'mohtavanegar'); ?></option>
                            <option value="top"><?php _e('بالا', 'mohtavanegar'); ?></option>
                            <option value="bottom"><?php _e('پایین', 'mohtavanegar'); ?></option>
                        </select>
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('سایه متن:', 'mohtavanegar'); ?></label>
                        <label style="display:inline-flex; align-items:center; cursor:pointer; height:35px;">
                            <input type="checkbox" id="title_shadow" checked> <?php _e('فعال باشد', 'mohtavanegar'); ?>
                        </label>
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('رنگ پس‌زمینه متن:', 'mohtavanegar'); ?></label>
                        <div style="display:flex; gap:10px;">
                            <input type="color" id="title_bg_color" value="#000000" style="flex:1; height:35px; border-radius:4px; border:1px solid #ccc;">
                            <input type="range" id="title_bg_opacity" min="0" max="100" value="0" style="flex:2;">
                            <span id="opacity_val" style="width:40px; text-align:center; line-height:35px;">0%</span>
                        </div>
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('گردی گوشه (Radius):', 'mohtavanegar'); ?></label>
                        <input type="number" id="title_bg_radius" value="10" min="0" max="100" style="width:100%; height:35px;">
                    </div>
                    <div>
                        <label style="display:block; margin-bottom:5px; font-weight:600;"><?php _e('حاشیه داخلی (Padding):', 'mohtavanegar'); ?></label>
                        <input type="number" id="title_bg_padding" value="20" min="0" max="100" style="width:100%; height:35px;">
                    </div>
                </div>
            </div>
        </div>
        <canvas id="video_canvas" style="display:none;"></canvas>

        <hr style="margin: 20px 0;">
        
        <div class="subtitles-section">
            <h4><?php _e('زیرنویس‌ها', 'mohtavanegar'); ?></h4>
            <div id="subtitles_container">
                <?php
                $subtitles = get_post_meta($post->ID, '_video_subtitles', true);
                if (!is_array($subtitles)) $subtitles = array();
                
                foreach ($subtitles as $index => $sub) :
                    $lang = isset($sub['lang']) ? $sub['lang'] : '';
                    $file = isset($sub['file']) ? $sub['file'] : '';
                ?>
                    <div class="subtitle-item" style="display:flex; gap:10px; margin-bottom:10px; align-items:center; background:#f9f9f9; padding:10px; border:1px solid #ddd; border-radius:5px;">
                        <input type="text" name="video_subtitles[<?php echo $index; ?>][lang]" value="<?php echo esc_attr($lang); ?>" placeholder="<?php _e('زبان (مثلا: فارسی)', 'mohtavanegar'); ?>" style="width:150px;">
                        <input type="text" name="video_subtitles[<?php echo $index; ?>][file]" value="<?php echo esc_attr($file); ?>" class="subtitle-file-url" placeholder="<?php _e('URL فایل زیرنویس (vtt)', 'mohtavanegar'); ?>" style="flex-grow:1;">
                        <button type="button" class="button upload_subtitle_btn"><?php _e('انتخاب فایل', 'mohtavanegar'); ?></button>
                        <button type="button" class="button button-link-delete remove-subtitle" style="color:#d63638;"><?php _e('حذف', 'mohtavanegar'); ?></button>
                    </div>
                <?php endforeach; ?>
            </div>
            <button type="button" id="add_subtitle_btn" class="button button-secondary" style="margin-top:10px;"><?php _e('افزودن زیرنویس جدید', 'mohtavanegar'); ?></button>
        </div>
    </div>
    <script>
    jQuery(document).ready(function($) {
        // ... (existing video upload code) ...
        var frame_custom_uploader;
        $('#upload_video_btn').click(function(e) {
            e.preventDefault();
            if (frame_custom_uploader) {
                frame_custom_uploader.open();
                return;
            }
            frame_custom_uploader = wp.media({
                title: '<?php _e('انتخاب ویدئو', 'mohtavanegar'); ?>',
                button: { text: '<?php _e('استفاده از این ویدئو', 'mohtavanegar'); ?>' },
                multiple: false,
                library: { type: 'video' }
            });
            frame_custom_uploader.on('select', function() {
                var attachment = frame_custom_uploader.state().get('selection').first().toJSON();
                $('#video_url').val(attachment.url);
                $('#video_capture_player').attr('src', attachment.url);
                $('#video_preview_wrapper').show();
            });
            frame_custom_uploader.open();
        });

        // Subtitle Repeatable Logic
        var subtitleIdx = <?php echo count($subtitles); ?>;
        
        $('#add_subtitle_btn').on('click', function() {
            var html = `
                <div class="subtitle-item" style="display:flex; gap:10px; margin-bottom:10px; align-items:center; background:#f9f9f9; padding:10px; border:1px solid #ddd; border-radius:5px;">
                    <input type="text" name="video_subtitles[${subtitleIdx}][lang]" value="" placeholder="<?php _e('زبان (مثلا: فارسی)', 'mohtavanegar'); ?>" style="width:150px;">
                    <input type="text" name="video_subtitles[${subtitleIdx}][file]" value="" class="subtitle-file-url" placeholder="<?php _e('URL فایل زیرنویس (vtt)', 'mohtavanegar'); ?>" style="flex-grow:1;">
                    <button type="button" class="button upload_subtitle_btn"><?php _e('انتخاب فایل', 'mohtavanegar'); ?></button>
                    <button type="button" class="button button-link-delete remove-subtitle" style="color:#d63638;"><?php _e('حذف', 'mohtavanegar'); ?></button>
                </div>
            `;
            $('#subtitles_container').append(html);
            subtitleIdx++;
        });

        $(document).on('click', '.remove-subtitle', function() {
            $(this).closest('.subtitle-item').remove();
        });

        var subtitle_uploader;
        $(document).on('click', '.upload_subtitle_btn', function(e) {
            e.preventDefault();
            var $button = $(this);
            var $input = $button.siblings('.subtitle-file-url');

            subtitle_uploader = wp.media({
                title: '<?php _e('انتخاب فایل زیرنویس', 'mohtavanegar'); ?>',
                button: { text: '<?php _e('استفاده از این فایل', 'mohtavanegar'); ?>' },
                multiple: false
            });

            subtitle_uploader.on('select', function() {
                var attachment = subtitle_uploader.state().get('selection').first().toJSON();
                $input.val(attachment.url);
            });

            subtitle_uploader.open();
        });

        // Toggle title settings
        $('#add_title_to_image').change(function() {
            if ($(this).is(':checked')) {
                // Pre-fill with post title if empty
                if (!$('#custom_title_text').val()) {
                    var postTitle = '';
                    if ($('#title').length) postTitle = $('#title').val();
                    if (!postTitle && typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
                        postTitle = wp.data.select('core/editor').getEditedPostAttribute('title');
                    }
                    $('#custom_title_text').val(postTitle);
                }
                $('#title_settings_wrapper').slideDown();
            } else {
                $('#title_settings_wrapper').slideUp();
            }
        });

        $('#title_bg_opacity').on('input', function() {
            $('#opacity_val').text($(this).val() + '%');
        });

        $('#capture_frame_btn').click(function() {
            var video = document.getElementById('video_capture_player');
            var canvas = document.getElementById('video_canvas');
            var context = canvas.getContext('2d');
            
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);
            
            // Add title if checkbox is checked
            if ($('#add_title_to_image').is(':checked')) {
                var titleText = $('#custom_title_text').val();
                
                if (titleText) {
                    var color = $('#title_color').val();
                    var fontFamily = $('#title_font_family').val();
                    var alignH = $('#title_align_h').val(); // center, left, right
                    var alignV = $('#title_align_v').val(); // middle, top, bottom
                    var hasShadow = $('#title_shadow').is(':checked');
                    var bgColor = $('#title_bg_color').val();
                    var bgOpacity = $('#title_bg_opacity').val() / 100;
                    var borderRadius = parseInt($('#title_bg_radius').val());
                    var padding = parseInt($('#title_bg_padding').val());
                    var fontSize = parseInt($('#title_font_size').val());

                    if (isNaN(fontSize) || fontSize <= 0) fontSize = Math.round(canvas.height * 0.08);

                    context.font = 'bold ' + fontSize + 'px ' + fontFamily;
                    context.textBaseline = 'middle';
                    
                    var lines = titleText.split('\n');
                    var lineHeight = fontSize * 1.3;
                    var totalTextHeight = lines.length * lineHeight;
                    
                    // Find max width
                    var maxLineWidth = 0;
                    for (var i = 0; i < lines.length; i++) {
                        var m = context.measureText(lines[i]).width;
                        if (m > maxLineWidth) maxLineWidth = m;
                    }

                    // Calculate position
                    var startX, startY;
                    var textAlign = alignH;
                    
                    if (alignH === 'center') {
                        startX = canvas.width / 2;
                    } else if (alignH === 'left') {
                        startX = padding;
                        textAlign = 'left';
                    } else if (alignH === 'right') {
                        startX = canvas.width - padding;
                        textAlign = 'right';
                    }

                    if (alignV === 'middle') {
                        startY = (canvas.height / 2) - (totalTextHeight / 2) + (lineHeight / 2);
                    } else if (alignV === 'top') {
                        startY = padding + (lineHeight / 2);
                    } else if (alignV === 'bottom') {
                        startY = canvas.height - padding - totalTextHeight + (lineHeight / 2);
                    }

                    // Draw Background Box if opacity > 0
                    if (bgOpacity > 0) {
                        context.save();
                        var rectX, rectY, rectW, rectH;
                        rectW = maxLineWidth + (padding * 2);
                        rectH = totalTextHeight + (padding * 1.5);
                        
                        if (alignH === 'center') rectX = (canvas.width / 2) - (rectW / 2);
                        else if (alignH === 'left') rectX = padding - (padding / 2);
                        else if (alignH === 'right') rectX = canvas.width - maxLineWidth - (padding * 1.5);

                        rectY = startY - (lineHeight / 2) - (padding / 2);

                        // Helper for rounded rect
                        function roundedRect(ctx, x, y, width, height, radius) {
                            ctx.beginPath();
                            ctx.moveTo(x + radius, y);
                            ctx.lineTo(x + width - radius, y);
                            ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
                            ctx.lineTo(x + width, y + height - radius);
                            ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
                            ctx.lineTo(x + radius, y + height);
                            ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
                            ctx.lineTo(x, y + radius);
                            ctx.quadraticCurveTo(x, y, x + radius, y);
                            ctx.closePath();
                        }

                        var hex = bgColor.replace('#', '');
                        var r = parseInt(hex.substring(0, 2), 16);
                        var g = parseInt(hex.substring(2, 4), 16);
                        var b = parseInt(hex.substring(4, 6), 16);
                        
                        context.fillStyle = 'rgba(' + r + ',' + g + ',' + b + ',' + bgOpacity + ')';
                        roundedRect(context, rectX, rectY, rectW, rectH, borderRadius);
                        context.fill();
                        context.restore();
                    }

                    // Set text properties
                    context.fillStyle = color;
                    context.textAlign = textAlign;
                    
                    if (hasShadow) {
                        context.shadowColor = 'rgba(0, 0, 0, 0.8)';
                        context.shadowBlur = 10;
                        context.shadowOffsetX = 2;
                        context.shadowOffsetY = 2;
                    } else {
                        context.shadowColor = 'transparent';
                    }
                    
                    // Draw title line by line
                    for (var i = 0; i < lines.length; i++) {
                        context.fillText(lines[i], startX, startY + (i * lineHeight));
                    }
                    
                    // Reset shadow
                    context.shadowColor = 'transparent';
                }
            }
            
            var dataURL = canvas.toDataURL('image/jpeg');
            var $status = $('#capture_status');
            $status.text('<?php _e('در حال پردازش...', 'mohtavanegar'); ?>');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'mohtavanegar_save_video_frame',
                    post_id: <?php echo $post->ID; ?>,
                    image_data: dataURL,
                    nonce: '<?php echo wp_create_nonce('save_video_frame_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        $status.text('<?php _e('تصویر شاخص با موفقیت تنظیم شد.', 'mohtavanegar'); ?>').css('color', 'green');
                        // نوسازی تصویر شاخص در صفحه ادمین
                        if ($('#set-post-thumbnail img').length) {
                             $('#set-post-thumbnail img').attr('src', response.data.url);
                        } else {
                             location.reload(); // ساده‌ترین راه برای نمایش تغییر
                        }
                    } else {
                        $status.text('<?php _e('خطا در ذخیره تصویر.', 'mohtavanegar'); ?>').css('color', 'red');
                    }
                }
            });
        });
    });
    </script>
    <?php
}

/**
 * Save Meta Box Data
 */
function mohtavanegar_save_video_meta($post_id) {
    if (!isset($_POST['mohtavanegar_video_meta_nonce']) || !wp_verify_nonce($_POST['mohtavanegar_video_meta_nonce'], 'mohtavanegar_save_video_meta')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (isset($_POST['video_url'])) {
        update_post_meta($post_id, '_video_url', esc_url_raw($_POST['video_url']));
    }

    if (isset($_POST['video_subtitles']) && is_array($_POST['video_subtitles'])) {
        $sanitized_subtitles = array();
        foreach ($_POST['video_subtitles'] as $sub) {
            if (!empty($sub['file'])) {
                $sanitized_subtitles[] = array(
                    'lang' => sanitize_text_field($sub['lang']),
                    'file' => esc_url_raw($sub['file'])
                );
            }
        }
        update_post_meta($post_id, '_video_subtitles', $sanitized_subtitles);
    } else {
        delete_post_meta($post_id, '_video_subtitles');
    }
}
add_action('save_post', 'mohtavanegar_save_video_meta');

/**
 * AJAX Handler to save captured frame
 */
function mohtavanegar_save_video_frame_ajax() {
    check_ajax_referer('save_video_frame_nonce', 'nonce');
    
    $post_id = intval($_POST['post_id']);
    $image_data = $_POST['image_data'];
    
    if (!$post_id || !$image_data) {
        wp_send_json_error();
    }

    // Decode base64
    $image_data = str_replace('data:image/jpeg;base64,', '', $image_data);
    $image_data = str_replace(' ', '+', $image_data);
    $decoded_data = base64_decode($image_data);
    
    $filename = 'video-thumb-' . $post_id . '-' . time() . '.jpg';
    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['path'] . '/' . $filename;
    
    file_put_contents($file_path, $decoded_data);
    
    $wp_filetype = wp_check_filetype($filename, null);
    $attachment = array(
        'post_mime_type' => $wp_filetype['type'],
        'post_title'     => sanitize_file_name($filename),
        'post_content'   => '',
        'post_status'    => 'inherit'
    );
    
    $attach_id = wp_insert_attachment($attachment, $file_path, $post_id);
    require_once(ABSPATH . 'wp-admin/includes/image.php');
    $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
    wp_update_attachment_metadata($attach_id, $attach_data);
    
    set_post_thumbnail($post_id, $attach_id);
    
    wp_send_json_success(array('url' => wp_get_attachment_url($attach_id)));
}
add_action('wp_ajax_mohtavanegar_save_video_frame', 'mohtavanegar_save_video_frame_ajax');

/**
 * Enqueue Scripts for Video Gallery
 */
function mohtavanegar_video_gallery_scripts() {
    if (is_singular('video_gallery') || is_page_template('single-video_gallery.php')) {
        wp_enqueue_style('plyr-css', 'https://cdn.plyr.io/3.7.8/plyr.css', array(), '3.7.8');
        wp_enqueue_script('plyr-js', 'https://cdn.plyr.io/3.7.8/plyr.polyfilled.js', array(), '3.7.8', true);
    }
}
add_action('wp_enqueue_scripts', 'mohtavanegar_video_gallery_scripts');
