<?php
/**
 * Template Name: Single Video Gallery
 * Description: A custom template for displaying single video gallery posts with Plyr support.
 */

get_header(); 

// Enqueue Plyr CDNs directly here if not enqueued globally, or rely on the enqueue in functions
// For robustness, we'll output the styles/scripts here if they aren't already handled, 
// but ideally they should be in the wp_enqueue_scripts hook.
// We will add the enqueue logic in the post type file as planned.
?>

<div class="mohtavanegar-single-video-wrapper" style="max-width: 1200px; margin: 40px auto; padding: 0 20px;">
    <?php while ( have_posts() ) : the_post(); 
        $video_url = get_post_meta( get_the_ID(), '_video_url', true );
        $subtitles = get_post_meta( get_the_ID(), '_video_subtitles', true );
        if ( ! is_array( $subtitles ) ) $subtitles = array();
    ?>
    
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        
        <header class="entry-header" style="margin-bottom: 20px;">
            <h1 class="entry-title" style="font-size: 2rem; font-weight: bold; color: #333;"><?php the_title(); ?></h1>
            <div class="entry-meta" style="color: #666; font-size: 0.9rem; margin-top: 10px;">
                <span><i class="dashicons dashicons-calendar-alt"></i> <?php echo get_the_date(); ?></span>
                <?php 
                $terms = get_the_terms( get_the_ID(), 'video_category' );
                if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                    echo ' | <span class="video-categories"><i class="dashicons dashicons-category"></i> ';
                    $term_list = [];
                    foreach ( $terms as $term ) {
                        $term_list[] = '<a href="' . esc_url( get_term_link( $term ) ) . '" style="text-decoration: none; color: inherit;">' . esc_html( $term->name ) . '</a>';
                    }
                    echo implode( ', ', $term_list );
                    echo '</span>';
                }
                ?>
            </div>
        </header>

        <?php if ( $video_url ) : ?>
        <div class="video-player-container" style="margin-bottom: 30px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); border-radius: 12px; overflow: hidden; background: #000;">
            <video id="player" playsinline controls data-poster="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>">
                <source src="<?php echo esc_url( $video_url ); ?>" type="video/mp4" />
                <?php foreach ( $subtitles as $index => $sub ) : 
                    if ( empty( $sub['file'] ) ) continue; 
                ?>
                    <track kind="captions" 
                           label="<?php echo esc_attr( $sub['lang'] ); ?>" 
                           srclang="<?php echo esc_attr( strtolower( $sub['lang'] ) ); ?>" 
                           src="<?php echo esc_url( $sub['file'] ); ?>" 
                           <?php echo $index === 0 ? 'default' : ''; ?> />
                <?php endforeach; ?>
            </video>
        </div>
        <?php endif; ?>

        <div class="entry-content" style="background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); line-height: 1.8;">
            <?php the_content(); ?>
        </div>
        
        <div class="video-comments" style="margin-top: 40px;">
            <?php
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;
            ?>
        </div>

    </article>

    <?php endwhile; ?>
</div>

<?php
// Add inline script to initialize Plyr after it's loaded
$plyr_init_script = "
document.addEventListener('DOMContentLoaded', () => {
    if (typeof Plyr !== 'undefined') {
        const player = new Plyr('#player', {
            controls: ['play-large', 'play', 'progress', 'current-time', 'mute', 'volume', 'captions', 'settings', 'pip', 'airplay', 'fullscreen'],
            captions: { active: true, update: true, language: 'auto' }
        });
    }
});
";
wp_add_inline_script('plyr-js', $plyr_init_script);
?>

<style>
/* Add some basic Plyr customization if needed */
:root {
    --plyr-color-main: #3498db;
}
.entry-content p {
    margin-bottom: 1.5em;
}
</style>

<?php get_footer(); ?>
