<?php
get_header();

// اگر قالب آرشیو المنتور وجود داشت، همان را لود کن و ادامه کد اجرا نشود
if ( function_exists('elementor_theme_do_location') && elementor_theme_do_location('archive') ) {
    return;
}

$term = get_queried_object();

// گرفتن زیرشاخه‌های این دسته‌بندی
$child_terms = get_terms(array(
    'taxonomy' => 'portfolio_category',
    'parent' => $term->term_id,
    'hide_empty' => false,
));

// گرفتن پست‌های portfolio این دسته‌بندی
$args = array(
    'post_type' => 'portfolio',
    'posts_per_page' => -1,
    'tax_query' => array(
        array(
            'taxonomy' => 'portfolio_category',
            'field'    => 'slug',
            'terms'    => $term->slug,
            'include_children' => false,
        ),
    ),
);

$query = new WP_Query($args);

// نمایش زیرشاخه‌ها اگر وجود داشتند
echo '<section class="portfolio-grid-section">';
echo '<h1 class="portfolio-category-title">' . esc_html($term->name) . '</h1>';
if (!empty($child_terms)) :
    echo '<div class="portfolio-grid">';
    foreach ($child_terms as $child) :
        $child_link = get_term_link($child);
        echo '<div class="portfolio-item">';
        echo '<a href="' . esc_url($child_link) . '">';
        // اگر تصویر شاخص برای دسته وجود داشت (ACF یا افزونه دیگر)، اینجا نمایش بده
        // فعلاً فقط نام دسته
        echo '<div class="portfolio-thumb portfolio-term-thumb">';
        $icon_id = get_term_meta($child->term_id, 'taxonomy_icon', true);
 
        if (!empty($icon_id)) {
            echo wp_get_attachment_image($icon_id, 'large');
           # echo '<img src="' . esc_url($icon_url) . '" alt="' . esc_attr($child->name) . '" style="max-width:100px;max-height:100px;object-fit:contain;" />';
        }
        echo '</div>';
        echo '<h2 class="portfolio-title">' . esc_html($child->name) . '</h2>';
        echo '</a>';
        echo '</div>';
    endforeach;
    echo '</div>';
endif;
echo '</section>';

// نمایش پست‌های portfolio اگر وجود داشتند
if ($query->have_posts()) : ?>
    <section class="portfolio-grid-section">
        <h2 class="portfolio-category-title">نمونه کارها</h2>
        <div class="portfolio-grid">
            <?php while ($query->have_posts()) : $query->the_post(); ?>
                <div class="portfolio-item">
                    <a href="<?php the_permalink(); ?>">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="portfolio-thumb">
                                <?php the_post_thumbnail('medium'); ?>
                            </div>
                        <?php endif; ?>
                        <h2 class="portfolio-title"><?php the_title(); ?></h2>
                    </a>
                </div>
            <?php endwhile; ?>
        </div>
    </section>
    <?php
    wp_reset_postdata();
else :
    if (empty($child_terms)) {
        echo '<p style="text-align:center;">هیچ نمونه کاری و زیرشاخه‌ای در این دسته‌بندی وجود ندارد.</p>';
    }
endif;

get_footer();