<?php
/**
 * The template for displaying services_category taxonomy archive
 */

get_header();

// Get basic settings with defaults
$basic_settings = get_option('basic_settings', array(
    'container_width' => '1140',
    'page_layout' => 'container'
));

// Get service settings with defaults
$defaults = array(
    'service_button_color' => '#0073aa',
    'service_button_text_color' => '#ffffff',
    'category_icon_bg' => '#f5f5f5',
    'subcategory_image_width' => 300,
    'subcategory_image_height' => 200,
    'show_view_button' => 'on',
    'show_description' => 'on',
    'subcategory_columns' => 3
);
$service_settings = wp_parse_args(get_option('service_settings', array()), $defaults);

// Set variables from settings
$service_button_color = $service_settings['service_button_color'];
$service_button_text_color = $service_settings['service_button_text_color'];
$category_icon_bg = $service_settings['category_icon_bg'];
$subcategory_image_size = array(
    'width' => absint($service_settings['subcategory_image_width']),
    'height' => absint($service_settings['subcategory_image_height']),
    'crop' => true
);
$show_view_button = $service_settings['show_view_button'] === 'on';
$show_description = $service_settings['show_description'] === 'on';
$subcategory_columns = max(1, min(6, absint($service_settings['subcategory_columns'])));

// Add custom image size for subcategory thumbnails
add_image_size('service_subcategory_thumb', $subcategory_image_size['width'], $subcategory_image_size['height'], $subcategory_image_size['crop']);
?>

<style>
.read-more-btn {
    background-color: <?php echo esc_attr($service_button_color); ?>;
    color: <?php echo esc_attr($service_button_text_color); ?>;
}
.term-icon {
    border-radius: 50%;
    padding: 15px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin-left: 15px;
}
.services-grid, .subcategories-grid {
    display: grid;
    grid-template-columns: repeat(<?php echo esc_attr($subcategory_columns); ?>, 1fr);
    gap: 20px;
    margin: 20px 0;
}
@media (max-width: 1024px) {
    .services-grid, .subcategories-grid {
        grid-template-columns: repeat(<?php echo min(3, $subcategory_columns); ?>, 1fr);
    }
}
@media (max-width: 768px) {
    .services-grid, .subcategories-grid {
        grid-template-columns: repeat(<?php echo min(2, $subcategory_columns); ?>, 1fr);
    }
}
@media (max-width: 480px) {
    .services-grid, .subcategories-grid {
        grid-template-columns: 1fr;
    }
}
.service-card img {
    width: 100%;
    height: auto;
    object-fit: cover;
}

.term-icon img {
    background-color: <?php echo esc_attr($category_icon_bg); ?>;
    padding: 10px;
    border-radius: 50%;
}
</style>

<main id="primary" class="site">
    <div class="<?php echo $basic_settings['page_layout'] === 'full-width' ? 'container-fluid' : 'container'; ?>" <?php echo $basic_settings['page_layout'] === 'container' ? 'style="max-width: ' . esc_attr($basic_settings['container_width']) . 'px;"' : ''; ?>>
        <header class="page-header">
            <?php
            $term = get_queried_object();
            $term_icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
            $has_term_icon = !empty($term_icon_id);
            ?>
            <div class="term-header-content">
                <?php if ($has_term_icon) : ?>
                <div class="term-icon">
                    <?php echo wp_get_attachment_image($term_icon_id, 'thumbnail'); ?>
                </div>
                <?php endif; ?>
                <div class="term-text">
                    <h1 class="page-title"><?php echo esc_html($term->name); ?></h1>
                    <?php if (!empty($term->description)) : ?>
                        <div class="archive-description"><?php echo wp_kses_post(wpautop(do_shortcode($term->description))); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </header>

        <div class="services_category-content">
            <?php
            // Get the current term and ensure it's valid
            $current_term = get_queried_object();
            
            // Display posts in this category - Show only direct posts of current category
            $services_query = new WP_Query(array(
                'post_type' => 'services',
                'posts_per_page' => -1, // Show all posts
                'tax_query' => array(
                    array(
                        'taxonomy' => 'services_category',
                        'field' => 'term_id',
                        'terms' => $current_term->term_id,
                        'include_children' => false, // Don't include posts from child categories
                    ),
                ),
                'orderby' => 'title',
                'order' => 'ASC',
            ));

            if ($services_query->have_posts()) :
                ?>
                <div class="services-section">
                    <h2 class="section-title"><?php esc_html_e('خدمات', 'mohtavanegar'); ?></h2>
                    <div class="subcategories-grid">
                        <?php
                        while ($services_query->have_posts()) :
                            $services_query->the_post();
                            ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class('service-card'); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="service-thumbnail">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail('medium'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="service-content">
                                    <header class="entry-header">
                                        <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                                    </header>

                                    <?php if ($show_description) : ?>
                                    <div class="entry-content">
                                        <?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($show_view_button) : ?>
                                    <div class="service-footer">
                                        <a href="<?php the_permalink(); ?>" class="read-more-btn">
                                            <?php esc_html_e('مشاهده جزئیات', 'mohtavanegar'); ?> <i class="fas fa-arrow-left"></i>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </article>
                            <?php
                        endwhile;
                        ?>
                    </div>
                </div>
                <?php
                wp_reset_postdata(); // Reset post data
            endif;

            if ($current_term && !is_wp_error($current_term)) {
                // Check if the current term has children
                $child_terms = get_terms(array(
                    'taxonomy' => 'services_category',
                    'parent' => $current_term->term_id,
                    'hide_empty' => false, // Show all subcategories regardless of posts
                    // We'll sort manually after fetching
                    'number' => 0, // No limit - show all subcategories
                ));

                // Display subcategories if they exist
                if (!empty($child_terms) && !is_wp_error($child_terms)) :
                    // Sort by display_order meta if set, otherwise by name
                    usort($child_terms, function($a, $b) {
                        $order_a = get_term_meta($a->term_id, 'display_order', true);
                        $order_b = get_term_meta($b->term_id, 'display_order', true);
                        if ($order_a === '' && $order_b === '') {
                            return strcasecmp($a->name, $b->name);
                        } elseif ($order_a === '') {
                            return 1;
                        } elseif ($order_b === '') {
                            return -1;
                        } elseif ($order_a == $order_b) {
                            return strcasecmp($a->name, $b->name);
                        } else {
                            return intval($order_a) - intval($order_b);
                        }
                    });
                    ?>
                    <div class="subcategories-section">
                        <h2 class="section-title"><?php esc_html_e('زیر دسته‌ها', 'mohtavanegar'); ?></h2>
                        <div class="services-subcategories">
                            <div class="taxonomy-display display-grid columns-3 mobile-columns-2">
                                <?php foreach ($child_terms as $child_term) : 
                                    $icon_id = get_term_meta($child_term->term_id, 'taxonomy_icon', true);
                                    $has_icon = !empty($icon_id);
                                    $term_count = $child_term->count;
                                    
                                    // Item class
                                    $item_class = 'taxonomy-item text-align-center subcategory-card';
                                    if ($has_icon) {
                                        $item_class .= ' has-icon icon-top';
                                    }
                                ?>
                                    <div class="<?php echo esc_attr($item_class); ?>">
                                        <a href="<?php echo get_term_link($child_term); ?>" class="taxonomy-card-link">
                                            <?php if ($has_icon) : ?>
                                                <div class="taxonomy-icon position-top">
                                                    <?php echo wp_get_attachment_image($icon_id, 'medium', false, array('style' => 'max-width: 100px; height: auto;')); ?>
                                                </div>
                                            <?php endif; ?>

                                            <div class="taxonomy-content">
                                                <h3 class="taxonomy-name"><?php echo esc_html($child_term->name); ?></h3>
                                                <span class="term-count"><?php printf(_n('%d خدمت', '%d خدمت', $term_count, 'mohtavanegar'), $term_count); ?></span>
                                                <?php if (!empty($child_term->description)) : ?>
                                                    <div class="term-description">
                                                        <?php echo wp_trim_words(do_shortcode($child_term->description), 15, '...'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <span class="view-more"><?php esc_html_e('مشاهده خدمات', 'mohtavanegar'); ?> <i class="fas fa-arrow-left"></i></span>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
            }
            
            ?>
        </div>
    </div>
</main>

<?php
get_footer();
