<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Floating_Contact_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'mohtavanegar_floating_contact';
    }

    public function get_title() {
        return esc_html__('دکمه شناور تماس', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-social-icons';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_keywords() {
        return ['contact', 'floating', 'button', 'social', 'mohtavanegar'];
    }

    public function get_style_depends() {
        wp_register_style(
            'floating-contact-widget-style',
            get_template_directory_uri() . '/assets/css/floating-contact-widget.css',
            array(),
            '1.0.0'
        );
        return ['floating-contact-widget-style'];
    }

    public function get_script_depends() {
        wp_register_script(
            'floating-contact-widget-script',
            get_template_directory_uri() . '/assets/js/floating-contact-widget.js',
            ['jquery'],
            '1.0.0',
            true
        );
        return ['floating-contact-widget-script'];
    }

    protected function register_controls() {
        // Items Section
        $this->start_controls_section(
            'items_section',
            [
                'label' => esc_html__('آیتم‌ها', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('عنوان آیتم', 'mohtavanegar'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('لینک', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'mohtavanegar'),
                'default' => [
                    'url' => '',
                ],
            ]
        );

        $repeater->add_control(
            'item_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .mn-floating-contact-item-icon' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .mn-floating-contact-item-title' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .mn-floating-contact-item-title::after' => 'border-left-color: {{VALUE}}', // Only works if triangle is on right (left aligned widget)
                ],
            ]
        );

        $repeater->add_control(
            'item_icon_color',
            [
                'label' => esc_html__('رنگ آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .mn-floating-contact-item-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $repeater->add_control(
            'item_text_color',
            [
                'label' => esc_html__('رنگ متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .mn-floating-contact-item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('لیست دکمه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('تماس با ما', 'mohtavanegar'),
                        'icon' => [
                            'value' => 'fas fa-phone',
                            'library' => 'solid',
                        ],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        // Settings Section
        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('تنظیمات دکمه اصلی', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_icon',
            [
                'label' => esc_html__('آیکون اصلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-comment',
                    'library' => 'solid',
                ],
            ]
        );
        
        $this->add_control(
            'main_icon_close',
            [
                'label' => esc_html__('آیکون بستن (اختیاری)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'description' => esc_html__('اگر انتخاب نشود، آیکون اصلی چرخش پیدا میکند.', 'mohtavanegar'),
                'default' => [
                    'value' => '',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'main_btn_text',
            [
                'label' => esc_html__('متن دکمه اصلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => esc_html__('مثلا: تماس بگیرید', 'mohtavanegar'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'position_h',
            [
                'label' => esc_html__('موقعیت افقی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'offset_x',
            [
                'label' => esc_html__('فاصله افقی (px)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-wrapper' => 'right: {{SIZE}}{{UNIT}}; left: auto;',
                    '{{WRAPPER}} .mn-floating-contact-wrapper.is-left' => 'left: {{SIZE}}{{UNIT}}; right: auto;',
                ],
            ]
        );

        $this->add_responsive_control(
            'offset_y',
            [
                'label' => esc_html__('فاصله عمودی (px)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-wrapper' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_gap',
            [
                'label' => esc_html__('فاصله لیست از دکمه (px)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'main_btn_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه اصلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#25D366',
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'main_btn_icon_color',
            [
                'label' => esc_html__('رنگ آیکون اصلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'main_btn_size',
            [
                'label' => esc_html__('اندازه دکمه اصلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 40,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; font-size: calc({{SIZE}}{{UNIT}} / 2.5);',
                ],
            ]
        );
        
        $this->add_control(
            'items_size',
            [
                'label' => esc_html__('اندازه دکمه‌های آیتم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 30,
                        'max' => 80,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-item-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; font-size: calc({{SIZE}}{{UNIT}} / 2.5);',
                ],
            ]
        );

        $this->end_controls_section();

        // Main Button Text Style Section
        $this->start_controls_section(
            'main_btn_text_style_section',
            [
                'label' => esc_html__('استایل متن دکمه اصلی', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'main_btn_text!' => '',
                ],
            ]
        );

        $this->add_control(
            'main_text_color',
            [
                'label' => esc_html__('رنگ متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-text span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'main_text_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-text span' => 'background-color: {{VALUE}}',
                    // Arrow color dynamic logic is better handled via specific transparent border override or simpler CSS if possible.
                    // For now let's apply it to background. Arrow will need specific handling or be CSS only.
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'main_text_typography',
                'label' => esc_html__('تایپوگرافی', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mn-floating-contact-main-text span',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'main_text_border',
                'label' => esc_html__('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mn-floating-contact-main-text span',
            ]
        );

        $this->add_control(
            'main_text_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-text span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'main_text_padding',
            [
                'label' => esc_html__('فاصله داخلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-text span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'main_text_margin',
            [
                'label' => esc_html__('فاصله خارجی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mn-floating-contact-main-text span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $wrapper_class = 'mn-floating-contact-wrapper';
        if ($settings['position_h'] === 'left') {
            $wrapper_class .= ' is-left';
        }

        ?>
        <div class="<?php echo esc_attr($wrapper_class); ?>">
            <div class="mn-floating-contact-main-btn">
                <?php \Elementor\Icons_Manager::render_icon($settings['main_icon'], ['aria-hidden' => 'true']); ?>
            </div>

            <?php if (!empty($settings['main_btn_text'])) : ?>
                <div class="mn-floating-contact-main-text">
                    <span><?php echo esc_html($settings['main_btn_text']); ?></span>
                </div>
            <?php endif; ?>

            <div class="mn-floating-contact-list">
                <?php foreach ($settings['items'] as $index => $item) : 
                    $link_attributes = 'class="mn-floating-contact-item-link"';
                    if (!empty($item['link']['url'])) {
                        $this->add_link_attributes('link_' . $index, $item['link']);
                        $link_attributes = $this->get_render_attribute_string('link_' . $index) . ' class="mn-floating-contact-item-link"';
                    }
                ?>
                    <div class="mn-floating-contact-item elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                        <a <?php echo $link_attributes; ?>>
                            <?php if (!empty($item['title'])) : ?>
                                <span class="mn-floating-contact-item-title"><?php echo esc_html($item['title']); ?></span>
                            <?php endif; ?>
                            
                            <div class="mn-floating-contact-item-icon">
                                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <style>
            /* Dynamic styles for triangle colors based on repeater item class */
            <?php foreach ($settings['items'] as $index => $item) : 
                if (!empty($item['item_bg_color'])) :
                    $id_class = '.elementor-repeater-item-' . $item['_id'];
            ?>
                /* Default (Right positioned widget) - triangle points right (to the icon) */
                .mn-floating-contact-wrapper:not(.is-left) <?php echo $id_class; ?> .mn-floating-contact-item-title::after {
                    border-color: transparent transparent transparent <?php echo $item['item_bg_color']; ?>;
                }
                
                /* Left positioned widget - triangle points left */
                .mn-floating-contact-wrapper.is-left <?php echo $id_class; ?> .mn-floating-contact-item-title::after {
                    border-color: transparent <?php echo $item['item_bg_color']; ?> transparent transparent;
                }
            <?php 
                endif;
            endforeach; 
            ?>
        </style>
        <?php
    }
}
