<?php
if (!defined('ABSPATH')) { exit; }

class Mohtavanegar_Related_Posts_Slider_Widget extends \Elementor\Widget_Base {
    public function get_name() { return 'mohtavanegar_related_posts_slider'; }
    public function get_title() { return esc_html__('پست‌های مرتبط (اسلایدر)', 'mohtavanegar'); }
    public function get_icon() { return 'eicon-posts-carousel'; }
    public function get_categories() { return ['mohtavanegar']; }

    protected function register_controls() {
        // Content
        $this->start_controls_section('content_section', [
            'label' => esc_html__('محتوا', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('posts_per_page', [
            'label' => esc_html__('تعداد پست‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1, 'max' => 50, 'default' => 6,
        ]);

        $this->add_control('show_date', [
            'label' => esc_html__('نمایش تاریخ', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);

        $this->add_control('show_comments', [
            'label' => esc_html__('نمایش تعداد نظرات', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);

        $this->add_control('show_thumbnail', [
            'label' => esc_html__('نمایش تصویر شاخص', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);

        $this->add_control('image_size', [
            'label' => esc_html__('اندازه تصویر شاخص', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'thumbnail' => esc_html__('تصویر بندانگشتی', 'mohtavanegar'),
                'medium'    => esc_html__('متوسط', 'mohtavanegar'),
                'large'     => esc_html__('بزرگ', 'mohtavanegar'),
                'full'      => esc_html__('کامل', 'mohtavanegar'),
            ],
            'default' => 'medium',
            'condition' => [ 'show_thumbnail' => 'yes' ],
        ]);

        // Slider behavior
        $this->add_control('enable_autoplay', [
            'label' => esc_html__('پخش خودکار', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
            'separator' => 'before',
        ]);
        $this->add_control('autoplay_delay', [
            'label' => esc_html__('زمان انتظار (ms)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 100, 'max' => 20000, 'step' => 100,
            'default' => 3500,
            'condition' => [ 'enable_autoplay' => 'yes' ],
        ]);
        $this->add_control('slide_speed', [
            'label' => esc_html__('سرعت پخش (ms)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 100, 'max' => 10000, 'step' => 50,
            'default' => 600,
        ]);
        $this->add_control('show_arrows', [
            'label' => esc_html__('نمایش فلش‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);
        $this->add_control('show_pagination', [
            'label' => esc_html__('نمایش نقاط (Pagination)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);
        $this->add_responsive_control('slides_per_view', [
            'label' => esc_html__('تعداد ستون‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => 3,
            'tablet_default' => 2,
            'mobile_default' => 1,
            'min' => 1, 'max' => 6,
        ]);
        $this->end_controls_section();

        // Style - Item
        $this->start_controls_section('item_style_section', [
            'label' => esc_html__('استایل آیتم', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->start_controls_tabs('item_bg_tabs');
        $this->start_controls_tab('item_bg_normal', [ 'label' => esc_html__('عادی', 'mohtavanegar') ]);
        $this->add_control('item_bg_color', [
            'label' => esc_html__('رنگ پس‌زمینه', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->start_controls_tab('item_bg_hover', [ 'label' => esc_html__('هاور', 'mohtavanegar') ]);
        $this->add_control('item_bg_color_hover', [
            'label' => esc_html__('رنگ پس‌زمینه (هاور)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card:hover' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control('item_padding', [
            'label' => esc_html__('فاصله داخلی', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(\Elementor\Group_Control_Border::get_type(), [
            'name' => 'item_border',
            'label' => esc_html__('حاشیه', 'mohtavanegar'),
            'selector' => '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card',
        ]);

        $this->add_responsive_control('item_border_radius', [
            'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('image_border_radius', [
            'label' => esc_html__('گردی تصویر شاخص', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [ 'show_thumbnail' => 'yes' ],
        ]);

        $this->add_control('item_text_align', [
            'label' => esc_html__('چینش متن', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'right' => [ 'title' => esc_html__('راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
                'center' => [ 'title' => esc_html__('وسط', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                'left' => [ 'title' => esc_html__('چپ', 'mohtavanegar'), 'icon' => 'eicon-text-align-left' ],
            ],
            'default' => 'inherit',
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-card' => 'text-align: {{VALUE}};',
            ],
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('رنگ عنوان', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-title a' => 'color: {{VALUE}};',
            ],
        ]);
        $this->add_control('meta_color', [
            'label' => esc_html__('رنگ متا', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-related-posts-slider .post-meta' => 'color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_section();
    }

    protected function render() {
        global $post;
        if (!$post || !is_singular()) { return; }
        $s = $this->get_settings_for_display();
        $current_title = get_the_title($post);
        if (!$current_title) { return; }

        $args = [
            'post_type' => 'post',
            's' => $current_title,
            'post_status' => 'publish',
            'posts_per_page' => isset($s['posts_per_page']) ? intval($s['posts_per_page']) : 6,
            'post__not_in' => [ $post->ID ],
            'orderby' => 'date',
            'order' => 'DESC',
        ];
        $q = new WP_Query($args);

        wp_enqueue_style('swiper');
        wp_enqueue_script('swiper');
        wp_enqueue_script(
            'related-posts-slider-js',
            get_template_directory_uri() . '/js/related-posts-slider.js',
            ['jquery','swiper'],
            file_exists(get_template_directory() . '/js/related-posts-slider.js') ? filemtime(get_template_directory() . '/js/related-posts-slider.js') : '1.0.0',
            true
        );
        wp_localize_script('related-posts-slider-js', 'RelatedPostsSliderVars', [ 'rtl' => is_rtl() ]);

        $slides_desktop = isset($s['slides_per_view']) && isset($s['slides_per_view']['size']) ? intval($s['slides_per_view']['size']) : 3;
        $slides_tablet  = isset($s['slides_per_view_tablet']) ? intval($s['slides_per_view_tablet']) : 2;
        $slides_mobile  = isset($s['slides_per_view_mobile']) ? intval($s['slides_per_view_mobile']) : 1;

        $autoplay = (isset($s['enable_autoplay']) && $s['enable_autoplay'] === 'yes');
        $delay    = isset($s['autoplay_delay']) ? intval($s['autoplay_delay']) : 3500;
        $speed    = isset($s['slide_speed']) ? intval($s['slide_speed']) : 600;
        $arrows   = (isset($s['show_arrows']) && $s['show_arrows'] === 'yes');
        $pagi     = (isset($s['show_pagination']) && $s['show_pagination'] === 'yes');

        $thumb_size = (!empty($s['image_size']) ? $s['image_size'] : 'medium');
        if ($q->have_posts()) {
            echo '<div class="mohtavanegar-related-posts-slider">';
            echo '<div class="swiper related-posts-swiper" '
                . 'data-slides-desktop="' . esc_attr($slides_desktop) . '" '
                . 'data-slides-tablet="' . esc_attr($slides_tablet) . '" '
                . 'data-slides-mobile="' . esc_attr($slides_mobile) . '" '
                . 'data-autoplay="' . esc_attr($autoplay ? '1' : '0') . '" '
                . 'data-delay="' . esc_attr($delay) . '" '
                . 'data-speed="' . esc_attr($speed) . '" '
                . 'data-arrows="' . esc_attr($arrows ? '1' : '0') . '" '
                . 'data-pagination="' . esc_attr($pagi ? '1' : '0') . '">'
                . '<div class="swiper-wrapper">';

            while ($q->have_posts()) { $q->the_post();
                echo '<div class="swiper-slide post-slide">';
                echo '<div class="post-card">';
                if (!empty($s['show_thumbnail']) && $s['show_thumbnail'] === 'yes' && has_post_thumbnail()) {
                    echo '<div class="post-thumb"><a href="' . esc_url(get_permalink()) . '">';
                    the_post_thumbnail($thumb_size);
                    echo '</a></div>';
                }
                echo '<div class="post-content">';
                echo '<h3 class="post-title" style="display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;"><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h3>';
                echo '<div class="post-meta">';
                if (!empty($s['show_date']) && $s['show_date'] === 'yes') {
                    echo '<span class="post-date">' . esc_html(get_the_date()) . '</span>';
                }
                if (!empty($s['show_comments']) && $s['show_comments'] === 'yes') {
                    echo '<span class="post-comments">' . intval(get_comments_number()) . '</span>';
                }
                echo '</div>';
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
            wp_reset_postdata();

            echo '</div>';
            if ($pagi) {
                echo '<div class="swiper-pagination"></div>';
            }
            if ($arrows) {
                echo '<div class="swiper-button-prev"></div><div class="swiper-button-next"></div>';
            }
            echo '</div>';
            echo '</div>';
        }
    }
}
