<?php
if (!defined('ABSPATH')) { exit; }

class Mohtavanegar_Reviews_Slider_Widget extends \Elementor\Widget_Base {
    public function get_name() { return 'mohtavanegar_reviews_slider'; }
    public function get_title() { return esc_html__('اسلایدر نظر بیماران', 'mohtavanegar'); }
    public function get_icon() { return 'eicon-slider-push'; }
    public function get_categories() { return ['mohtavanegar']; }

    private function get_services_options() {
        $options = [];
        $services = get_posts([
            'post_type' => 'services',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC'
        ]);
        foreach ($services as $service) { $options[$service->ID] = $service->post_title; }
        return $options;
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', [
            'label' => esc_html__('محتوا', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);
        $this->add_control('filter_by_service', [
            'label' => esc_html__('فیلتر بر اساس خدمت', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'all' => esc_html__('همه خدمات', 'mohtavanegar'),
                'specific' => esc_html__('خدمت خاص', 'mohtavanegar'),
            ],
            'default' => 'all',
        ]);
        $this->add_control('specific_service', [
            'label' => esc_html__('انتخاب خدمت', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => $this->get_services_options(),
            'condition' => [ 'filter_by_service' => 'specific' ],
            'multiple' => false,
        ]);
        $this->add_control('posts_per_page', [
            'label' => esc_html__('تعداد نمایش', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1, 'max' => 50, 'default' => 10,
        ]);
        $this->add_control('show_rating', [
            'label' => esc_html__('نمایش ستاره', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);
        // Slider behavior
        $this->add_control('enable_autoplay', [
            'label' => esc_html__('پخش خودکار', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
            'separator' => 'before',
        ]);
        $this->add_control('autoplay_delay', [
            'label' => esc_html__('زمان انتظار (ms)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 100, 'max' => 20000, 'step' => 100,
            'default' => 3500,
            'condition' => [ 'enable_autoplay' => 'yes' ],
        ]);
        $this->add_control('slide_speed', [
            'label' => esc_html__('سرعت پخش (ms)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 100, 'max' => 10000, 'step' => 50,
            'default' => 600,
        ]);
        $this->add_control('show_arrows', [
            'label' => esc_html__('نمایش Arrow', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);
        $this->add_control('show_pagination', [
            'label' => esc_html__('نمایش Pagination Bullets', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'yes', 'default' => 'yes',
        ]);
        // Responsive slides per view
        $this->add_responsive_control('slides_per_view', [
            'label' => esc_html__('تعداد آیتم در هر ردیف', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => 3,
            'tablet_default' => 2,
            'mobile_default' => 1,
            'min' => 1,
            'max' => 6,
        ]);
        $this->end_controls_section();

        // Arrows style section
        $this->start_controls_section('arrows_style_section', [
            'label' => esc_html__('استایل فلش‌ها', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => ['show_arrows' => 'yes'],
        ]);

        // Arrows size
        $this->add_responsive_control('arrows_size', [
            'label' => esc_html__('اندازه فلش‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [
                'px' => ['min' => 10, 'max' => 100],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .swiper-button-next:after, {{WRAPPER}} .swiper-button-prev:after' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Arrows color
        $this->start_controls_tabs('arrows_color_tabs');
        
        $this->start_controls_tab('arrows_color_normal', [
            'label' => esc_html__('عادی', 'mohtavanegar'),
        ]);
        
        $this->add_control('arrows_color', [
            'label' => esc_html__('رنگ', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'color: {{VALUE}};',
            ],
        ]);
        
        $this->end_controls_tab();
        
        $this->start_controls_tab('arrows_color_hover', [
            'label' => esc_html__('هاور', 'mohtavanegar'),
        ]);
        
        $this->add_control('arrows_color_hover', [
            'label' => esc_html__('رنگ (هاور)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'color: {{VALUE}};',
            ],
        ]);
        
        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Arrows background
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'arrows_bg',
                'label' => esc_html__('پس‌زمینه', 'mohtavanegar'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
            ]
        );

        // Arrows border
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrows_border',
                'label' => esc_html__('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev',
            ]
        );

        // Arrows border radius
        $this->add_control('arrows_border_radius', [
            'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // Arrows position
        $this->add_responsive_control('arrows_position', [
            'label' => esc_html__('موقعیت عمودی', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [
                'px' => ['min' => -100, 'max' => 500],
                '%' => ['min' => -20, 'max' => 100],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'top: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Arrows horizontal spacing
        $this->add_responsive_control('arrows_spacing', [
            'label' => esc_html__('فاصله افقی', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [
                'px' => ['min' => -100, 'max' => 100],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-button-next' => 'right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();

        // Pagination style section
        $this->start_controls_section('pagination_style_section', [
            'label' => esc_html__('استایل صفحه‌بندی', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => ['show_pagination' => 'yes'],
        ]);

        // Pagination position
        $this->add_responsive_control('pagination_position', [
            'label' => esc_html__('موقعیت', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [
                'px' => ['min' => -100, 'max' => 200],
                '%' => ['min' => 0, 'max' => 100],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Pagination size
        $this->add_responsive_control('pagination_size', [
            'label' => esc_html__('اندازه', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [
                'px' => ['min' => 4, 'max' => 30],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Pagination spacing
        $this->add_responsive_control('pagination_spacing', [
            'label' => esc_html__('فاصله بین نقاط', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [
                'px' => ['min' => 0, 'max' => 50],
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination-bullet' => 'margin: 0 {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Pagination colors
        $this->start_controls_tabs('pagination_color_tabs');
        
        $this->start_controls_tab('pagination_color_normal', [
            'label' => esc_html__('عادی', 'mohtavanegar'),
        ]);
        
        $this->add_control('pagination_color', [
            'label' => esc_html__('رنگ', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination-bullet' => 'background-color: {{VALUE}}; opacity: 1;',
            ],
        ]);
        
        $this->end_controls_tab();
        
        $this->start_controls_tab('pagination_color_active', [
            'label' => esc_html__('فعال', 'mohtavanegar'),
        ]);
        
        $this->add_control('pagination_color_active', [
            'label' => esc_html__('رنگ فعال', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
            ],
        ]);
        
        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Pagination border radius
        $this->add_control('pagination_border_radius', [
            'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();

        // Item style controls
        $this->start_controls_section('item_style_section', [
            'label' => esc_html__('استایل آیتم', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        // Background normal/hover
        $this->start_controls_tabs('item_bg_tabs');
        $this->start_controls_tab('item_bg_normal', [ 'label' => esc_html__('عادی', 'mohtavanegar') ]);
        $this->add_control('item_bg_color', [
            'label' => esc_html__('رنگ پس‌زمینه', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->start_controls_tab('item_bg_hover', [ 'label' => esc_html__('هاور', 'mohtavanegar') ]);
        $this->add_control('item_bg_color_hover', [
            'label' => esc_html__('رنگ پس‌زمینه (هاور)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card:hover' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Padding
        $this->add_responsive_control('item_padding', [
            'label' => esc_html__('فاصله داخلی آیتم', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; min-height: 500px;',
            ],
        ]);

        // Border
        $this->add_group_control(\Elementor\Group_Control_Border::get_type(), [
            'name' => 'item_border',
            'label' => esc_html__('حاشیه', 'mohtavanegar'),
            'selector' => '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card',
        ]);

        // Border radius
        $this->add_responsive_control('item_border_radius', [
            'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // Text alignment
        $this->add_control('item_text_align', [
            'label' => esc_html__('چینش متن', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [ 'title' => esc_html__('چپ', 'mohtavanegar'), 'icon' => 'eicon-text-align-left' ],
                'center' => [ 'title' => esc_html__('وسط', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                'right' => [ 'title' => esc_html__('راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
            ],
            'default' => 'inherit',
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-card' => 'text-align: {{VALUE}};',
            ],
        ]);
        $this->end_controls_section();

        // Stars color controls
        $this->start_controls_section('stars_style_section', [
            'label' => esc_html__('رنگ ستاره‌ها', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        // Size
        $this->add_responsive_control('star_size', [
            'label' => esc_html__('اندازه ستاره', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px','em','rem'],
            'range' => [
                'px' => ['min' => 8, 'max' => 80],
                'em' => ['min' => .5, 'max' => 5, 'step' => .1],
                'rem' => ['min' => .5, 'max' => 5, 'step' => .1],
            ],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-stars .star' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ]);
        // Spacing between stars
        $this->add_responsive_control('stars_gap', [
            'label' => esc_html__('فاصله بین ستاره‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px','em','rem'],
            'range' => [
                'px' => ['min' => 0, 'max' => 40],
                'em' => ['min' => 0, 'max' => 3, 'step' => .1],
                'rem' => ['min' => 0, 'max' => 3, 'step' => .1],
            ],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-stars' => 'gap: {{SIZE}}{{UNIT}};',
            ],
        ]);
        $this->add_control('star_color', [
            'label' => esc_html__('رنگ ستاره (غیرفعال)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-stars .star' => 'color: {{VALUE}};',
            ],
        ]);
        $this->add_control('star_filled_color', [
            'label' => esc_html__('رنگ ستاره (پرشده)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-slider-widget .review-stars .star.filled' => 'color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $args = [
            'post_type' => 'patient_review',
            'post_status' => 'publish',
            'posts_per_page' => intval($s['posts_per_page']),
            'orderby' => 'date',
            'order' => 'DESC',
        ];
        if ($s['filter_by_service'] === 'specific' && !empty($s['specific_service'])) {
            $args['meta_query'] = [
                [ 'key' => '_review_service', 'value' => intval($s['specific_service']), 'compare' => '=' ],
            ];
        }
        $q = new WP_Query($args);

        wp_enqueue_style('swiper');
        wp_enqueue_script('swiper');
        wp_enqueue_script(
            'reviews-slider-js',
            get_template_directory_uri() . '/js/reviews-slider.js',
            ['jquery','swiper'],
            file_exists(get_template_directory() . '/js/reviews-slider.js') ? filemtime(get_template_directory() . '/js/reviews-slider.js') : '1.0.0',
            true
        );
        wp_localize_script('reviews-slider-js', 'reviewsSliderVars', [ 'rtl' => is_rtl() ]);

        $slides_desktop = isset($s['slides_per_view']) && isset($s['slides_per_view']['size']) ? intval($s['slides_per_view']['size']) : 3;
        $slides_tablet  = isset($s['slides_per_view_tablet']) ? intval($s['slides_per_view_tablet']) : 2;
        $slides_mobile  = isset($s['slides_per_view_mobile']) ? intval($s['slides_per_view_mobile']) : 1;

        $autoplay = ($s['enable_autoplay'] === 'yes');
        $delay    = isset($s['autoplay_delay']) ? intval($s['autoplay_delay']) : 3500;
        $speed    = isset($s['slide_speed']) ? intval($s['slide_speed']) : 600;
        $arrows   = ($s['show_arrows'] === 'yes');
        $pagi     = ($s['show_pagination'] === 'yes');

        echo '<div class="mohtavanegar-reviews-slider-widget">';
        echo '<div class="swiper reviews-swiper" '
            . 'data-slides-desktop="' . esc_attr($slides_desktop) . '" '
            . 'data-slides-tablet="' . esc_attr($slides_tablet) . '" '
            . 'data-slides-mobile="' . esc_attr($slides_mobile) . '" '
            . 'data-autoplay="' . esc_attr($autoplay ? '1' : '0') . '" '
            . 'data-delay="' . esc_attr($delay) . '" '
            . 'data-speed="' . esc_attr($speed) . '" '
            . 'data-arrows="' . esc_attr($arrows ? '1' : '0') . '" '
            . 'data-pagination="' . esc_attr($pagi ? '1' : '0') . '">'
            . '<div class="swiper-wrapper">';
        if ($q->have_posts()) {
            while ($q->have_posts()) { $q->the_post();
                $name = get_post_meta(get_the_ID(), '_review_name', true);
                $rating = intval(get_post_meta(get_the_ID(), '_review_rating', true));
                $service_id = get_post_meta(get_the_ID(), '_review_service', true);
                $service_title = $service_id ? get_post($service_id)->post_title : '';
                echo '<div class="swiper-slide review-slide">';
                echo '<div class="review-card">';
                echo '<div class="review-header">';
                echo '<div class="review-name">' . esc_html($name ?: get_the_title()) . '</div>';
                if ($s['show_rating'] === 'yes') {
                    echo '<div class="review-stars">';
                    for ($i=1;$i<=5;$i++){ echo '<span class="star'.($i<= $rating?' filled':'').'">★</span>'; }
                    echo '</div>';
                }
                echo '</div>';
                if ($service_title) {
                    echo '<div class="review-service">' . esc_html($service_title) . '</div>';
                }
                echo '<div class="review-text">' . wp_kses_post(wpautop(get_the_content())) . '</div>';
                echo '</div>';
                echo '</div>';
            }
            wp_reset_postdata();
        } else {
            echo '<div class="swiper-slide">' . esc_html__('نظری یافت نشد.', 'mohtavanegar') . '</div>';
        }
        echo '</div>';
        if ($pagi) {
            echo '<div class="swiper-pagination"></div>';
        }
        if ($arrows) {
            echo '<div class="swiper-button-prev"></div><div class="swiper-button-next"></div>';
        }
        echo '</div>';
        echo '</div>';
    }
}
