<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Service_Categories_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'mohtavanegar_service_categories';
    }

    public function get_title() {
        return esc_html__('دسته بندی خدمات 03', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_keywords() {
        return ['services', 'categories', 'grid', 'mohtavanegar'];
    }

    protected function register_controls() {
        // ========================
        // Section: عمومی (General)
        // ========================
        $this->start_controls_section(
            'general_section',
            [
                'label' => esc_html__('عمومی', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد دسته‌بندی‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 6,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب‌سازی بر اساس', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'name',
                'options' => [
                    'name' => esc_html__('نام', 'mohtavanegar'),
                    'count' => esc_html__('تعداد مطالب', 'mohtavanegar'),
                    'term_order' => esc_html__('ترتیب سفارشی', 'mohtavanegar'),
                    'include' => esc_html__('ترتیب انتخابی', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => esc_html__('صعودی', 'mohtavanegar'),
                    'DESC' => esc_html__('نزولی', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'show_count',
            [
                'label' => esc_html__('نمایش تعداد مطالب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_subtitle',
            [
                'label' => esc_html__('نمایش زیر عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        // =====================
        // Section: آیکون (Icon)
        // =====================
        $this->start_controls_section(
            'icon_section',
            [
                'label' => esc_html__('آیکون', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__('نمایش آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label' => esc_html__('موقعیت آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'top-right',
                'options' => [
                    'top-right' => esc_html__('بالا راست', 'mohtavanegar'),
                    'top-left' => esc_html__('بالا چپ', 'mohtavanegar'),
                    'bottom-right' => esc_html__('پایین راست', 'mohtavanegar'),
                    'bottom-left' => esc_html__('پایین چپ', 'mohtavanegar'),
                ],
                'prefix_class' => 'service-category-icon-position-',
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('اندازه آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 24,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_container_size',
            [
                'label' => esc_html__('اندازه کادر آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => esc_html__('رنگ آیکون در حالت هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-icon' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_background',
            [
                'label' => esc_html__('پس‌زمینه آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__('حاشیه داخلی آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow',
                'label' => esc_html__('سایه آیکون', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-category-icon',
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_offset_x',
            [
                'label' => esc_html__('فاصله افقی آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}}.service-category-icon-position-top-right .service-category-icon' => 'right: {{SIZE}}{{UNIT}}; left: auto;',
                    '{{WRAPPER}}.service-category-icon-position-top-left .service-category-icon' => 'left: {{SIZE}}{{UNIT}}; right: auto;',
                    '{{WRAPPER}}.service-category-icon-position-bottom-right .service-category-icon' => 'right: {{SIZE}}{{UNIT}}; left: auto;',
                    '{{WRAPPER}}.service-category-icon-position-bottom-left .service-category-icon' => 'left: {{SIZE}}{{UNIT}}; right: auto;',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_offset_y',
            [
                'label' => esc_html__('فاصله عمودی آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}}.service-category-icon-position-top-right .service-category-icon' => 'top: {{SIZE}}{{UNIT}}; bottom: auto;',
                    '{{WRAPPER}}.service-category-icon-position-top-left .service-category-icon' => 'top: {{SIZE}}{{UNIT}}; bottom: auto;',
                    '{{WRAPPER}}.service-category-icon-position-bottom-right .service-category-icon' => 'bottom: {{SIZE}}{{UNIT}}; top: auto;',
                    '{{WRAPPER}}.service-category-icon-position-bottom-left .service-category-icon' => 'bottom: {{SIZE}}{{UNIT}}; top: auto;',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // =============================
        // Section: پس‌زمینه (Background)
        // =============================
        $this->start_controls_section(
            'background_section',
            [
                'label' => esc_html__('پس‌زمینه', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_type',
            [
                'label' => esc_html__('نوع پس‌زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('تصویر', 'mohtavanegar'),
                    'color' => esc_html__('رنگ', 'mohtavanegar'),
                    'gradient' => esc_html__('گرادیانت', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-item' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'background_type' => 'color',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_gradient',
                'label' => esc_html__('گرادیانت پس‌زمینه', 'mohtavanegar'),
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .service-category-item',
                'condition' => [
                    'background_type' => 'gradient',
                ],
            ]
        );

        $this->add_control(
            'hover_overlay',
            [
                'label' => esc_html__('روکش هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'mohtavanegar'),
                'label_off' => esc_html__('غیرفعال', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hover_overlay_color',
            [
                'label' => esc_html__('رنگ روکش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.5)',
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-overlay' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'hover_overlay' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // ===========================
        // Section: محتوا (Content)
        // ===========================
        $this->start_controls_section(
            'content_style_section',
            [
                'label' => esc_html__('محتوا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('content_style_tabs');

        $this->start_controls_tab(
            'content_normal_tab',
            ['label' => esc_html__('عادی', 'mohtavanegar')]
        );

        $this->add_control(
            'content_background',
            [
                'label' => esc_html__('رنگ پس‌زمینه محتوا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'background: {{VALUE}}',
                ],
                'default' => 'rgba(0,0,0,0.5)',
            ]
        );

        $this->add_control(
            'content_text_color',
            [
                'label' => esc_html__('رنگ متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .service-category-title' => 'color: {{VALUE}}',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_hover_tab',
            ['label' => esc_html__('هاور', 'mohtavanegar')]
        );

        $this->add_control(
            'content_hover_background',
            [
                'label' => esc_html__('رنگ پس‌زمینه در حالت هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-content' => 'background: {{VALUE}}',
                ],
                'default' => 'rgba(0,0,0,0.7)',
            ]
        );

        $this->add_control(
            'content_hover_text_color',
            [
                'label' => esc_html__('رنگ متن در حالت هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-content' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .service-category-item:hover .service-category-title' => 'color: {{VALUE}}',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'content_padding',
            [
                'label' => esc_html__('فاصله داخلی محتوا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_box_shadow',
                'selector' => '{{WRAPPER}} .service-category-content',
            ]
        );

        $this->add_control(
            'content_transition',
            [
                'label' => esc_html__('زمان انتقال انیمیشن (ثانیه)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0.3,
                ],
                'range' => [
                    'px' => [
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'transition: all {{SIZE}}s ease;',
                ],
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-categories-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
            ]
        );

        // Item Spacing
        $this->add_responsive_control(
            'gap',
            [
                'label' => esc_html__('فاصله بین آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 30,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 15,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-categories-grid' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Item Height
        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('ارتفاع کارت‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                        'step' => 10,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 250,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 200,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 180,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-category-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__('عنوان دسته‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-category-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_background',
            [
                'label' => esc_html__('پس‌زمینه عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_align',
            [
                'label' => esc_html__('تراز متن عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .service-category-title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_padding',
            [
                'label' => esc_html__('حاشیه داخلی عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        // Subtitle Style Section
        $this->add_control(
            'subtitle_heading',
            [
                'label' => esc_html__('زیر عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'label' => esc_html__('تایپوگرافی زیر عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-category-subtitle',
                'condition' => [
                    'show_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-category-subtitle' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_align',
            [
                'label' => esc_html__('تراز متن زیر عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .service-category-subtitle' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'show_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'subtitle_margin',
            [
                'label' => esc_html__('فاصله از عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-category-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_subtitle' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'hover_effects',
            [
                'label' => esc_html__('افکت‌های هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_zoom',
            [
                'label' => esc_html__('زوم تصویر در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'mohtavanegar'),
                'label_off' => esc_html__('غیرفعال', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-bg' => 'transform: scale(1.1);',
                ],
            ]
        );

        $this->add_control(
            'hover_overlay',
            [
                'label' => esc_html__('روکش تیره در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'mohtavanegar'),
                'label_off' => esc_html__('غیرفعال', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hover_overlay_color',
            [
                'label' => esc_html__('رنگ روکش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.5)',
                'selectors' => [
                    '{{WRAPPER}} .service-category-item:hover .service-category-overlay' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'hover_overlay' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        // First, get all categories
        $args = [
            'taxonomy' => 'services_category',
            'hide_empty' => false,
            'number' => $settings['number'],
            'orderby' => 'name', // Default order by name
            'order' => 'ASC',
        ];

        // If order by display_order is selected
        if ($settings['orderby'] === 'meta_value_num') {
            $args['meta_key'] = 'display_order';
            $args['orderby'] = 'meta_value_num';
            $args['meta_query'] = [
                'relation' => 'OR',
                [
                    'key' => 'display_order',
                    'compare' => 'NOT EXISTS',
                ],
                [
                    'key' => 'display_order',
                    'compare' => '>=',
                    'value' => 0,
                    'type' => 'NUMERIC',
                ],
            ];
        }

        $categories = get_terms($args);
        
        // Debug information
        if (is_wp_error($categories)) {
            echo '<div style="background: #f8d7da; color: #721c24; padding: 10px; margin: 10px 0; border: 1px solid #f5c6cb; border-radius: 4px;">';
            echo '<p><strong>خطا در دریافت دسته‌بندی‌ها:</strong> ' . $categories->get_error_message() . '</p>';
            echo '</div>';
        }
        
        if (empty($categories) || is_wp_error($categories)) {
            echo '<div style="background: #fff3cd; color: #856404; padding: 10px; margin: 10px 0; border: 1px solid #ffeeba; border-radius: 4px;">';
            echo '<p>' . esc_html__('هیچ دسته‌بندی‌ای یافت نشد.', 'mohtavanegar') . '</p>';
            echo '<p><strong>پارامترهای جستجو:</strong></p>';
            echo '<pre>' . print_r($args, true) . '</pre>';
            
            // Get all terms without any filters
            $all_terms = get_terms([
                'taxonomy' => 'services_category',
                'hide_empty' => false,
                'number' => 0
            ]);
            
            if (!empty($all_terms) && !is_wp_error($all_terms)) {
                echo '<p><strong>تمامی دسته‌بندی‌های موجود:</strong> ' . count($all_terms) . ' مورد</p>';
                echo '<ul>';
                foreach ($all_terms as $term) {
                    echo '<li>' . esc_html($term->name) . ' (ID: ' . $term->term_id . ')</li>';
                }
                echo '</ul>';
            } else {
                echo '<p>هیچ دسته‌بندی‌ای در سیستم یافت نشد.</p>';
            }
            
            echo '</div>';
            return;
        }

        $hover_zoom_class = $settings['hover_zoom'] === 'yes' ? 'has-zoom-effect' : '';
        $hover_overlay_class = $settings['hover_overlay'] === 'yes' ? 'has-overlay' : '';
        ?>

        <div class="service-categories-container">
            <div class="service-categories-grid <?php echo esc_attr($hover_zoom_class . ' ' . $hover_overlay_class); ?>">
                <?php 
                // Debug information
                error_log('Categories found: ' . print_r(wp_list_pluck($categories, 'name', 'term_id'), true));
                
                foreach ($categories as $category) : 
                    $icon_id = get_term_meta($category->term_id, 'taxonomy_icon', true);
                    $background_image_id = get_term_meta($category->term_id, 'taxonomy_background_image', true);
                    
                    // Debug information
                    error_log("Category ID: {$category->term_id}, Icon ID: {$icon_id}, BG ID: {$background_image_id}");
                    
                    // Get the actual image URLs
                    $icon_url = '';
                    if ($icon_id) {
                        $icon_src = wp_get_attachment_image_src($icon_id, 'thumbnail');
                        $icon_url = $icon_src ? $icon_src[0] : '';
                    }
                    
                    $background_image_url = '';
                    if ($background_image_id) {
                        $bg_src = wp_get_attachment_image_src($background_image_id, 'large');
                        $background_image_url = $bg_src ? $bg_src[0] : '';
                    }
                    
                    // Debug the URLs
                    error_log("Category: {$category->name}, Icon URL: {$icon_url}, BG URL: {$background_image_url}");
                    $category_link = get_term_link($category);
                ?>
                    <a href="<?php echo esc_url($category_link); ?>" class="service-category-item">
                        <?php if ($background_image_url) : ?>
                            <div class="service-category-bg" style="background-image: url('<?php echo esc_url($background_image_url); ?>'); background-size: cover; background-position: center; background-repeat: no-repeat;"></div>
                        <?php endif; ?>
                        
                        <?php if ($settings['hover_overlay'] === 'yes') : ?>
                            <div class="service-category-overlay"></div>
                        <?php endif; ?>
                        
                        <div class="service-category-content">
                            <?php if ($icon_url) : ?>
                                <div class="service-category-icon">
                                    <img src="<?php echo esc_url($icon_url); ?>" alt="<?php echo esc_attr($category->name); ?>" />
                                </div>
                            <?php endif; ?>
                            <div class="service-category-content-inner">
                                <h3 class="service-category-title">
                                    <?php echo esc_html($category->name); ?>
                                    <?php if ($settings['show_count'] === 'yes') : ?>
                                        <span class="service-category-count">(<?php echo esc_html($category->count); ?>)</span>
                                    <?php endif; ?>
                                </h3>
                                <?php 
                                if ($settings['show_subtitle'] === 'yes') : 
                                    $subtitle = get_term_meta($category->term_id, 'taxonomy_subtitle', true);
                                    if (!empty($subtitle)) : 
                                ?>
                                    <div class="service-category-subtitle"><?php echo esc_html($subtitle); ?></div>
                                <?php 
                                    endif;
                                endif; 
                                ?>
                                <?php if (!empty($category->description)) : ?>
                                    <div class="service-category-description">
                                        <?php echo wp_kses_post($category->description); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}
