<?php
if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

class Mohtavanegar_Services_Grid_04_Widget extends Widget_Base {

    public function get_name() {
        return 'mohtavanegar-services-grid-04';
    }

    public function get_title() {
        return __('نمایش خدمات 04', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_style_depends() {
        return ['services-grid-04-widget'];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => __('تعداد سرویس‌ها', 'mohtavanegar'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'max' => 100,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('مرتب‌سازی بر اساس', 'mohtavanegar'),
                'type' => Controls_Manager::SELECT,
                'default' => 'name',
                'options' => [
                    'name' => __('نام', 'mohtavanegar'),
                    'count' => __('تعداد مطالب', 'mohtavanegar'),
                    'term_id' => __('آی‌دی', 'mohtavanegar'),
                    'meta_value_num' => __('ترتیب سفارشی (display_order)', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('ترتیب', 'mohtavanegar'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => __('صعودی', 'mohtavanegar'),
                    'DESC' => __('نزولی', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'hide_empty',
            [
                'label' => __('مخفی کردن دسته‌های خالی', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_image',
            [
                'label' => __('نمایش تصویر', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_count',
            [
                'label' => __('نمایش تعداد مطالب', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_description',
            [
                'label' => __('نمایش توضیحات', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'description_length',
            [
                'label' => __('حداکثر تعداد کاراکتر توضیحات', 'mohtavanegar'),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 1,
                'default' => 0,
                'description' => __('برای نمایش کامل متن 0 وارد کنید', 'mohtavanegar'),
                'condition' => [
                    'show_description' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description_after_text',
            [
                'label' => __('متن پس از توضیحات کوتاه', 'mohtavanegar'),
                'type' => Controls_Manager::TEXT,
                'default' => '...',
                'description' => __('متن نمایشی پس از توضیحات کوتاه', 'mohtavanegar'),
                'condition' => [
                    'show_description' => 'yes',
                    'description_length[value]!' => 0,
                ],
            ]
        );

        $this->add_control(
            'show_subtitle',
            [
                'label' => __('نمایش زیرعنوان', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'exclude',
            [
                'label' => __('حذف دسته‌ها', 'mohtavanegar'),
                'type' => 'mohtavanegar-query',
                'post_type' => '',
                'options' => [],
                'label_block' => true,
                'multiple' => true,
                'query_type' => 'terms',
                'taxonomy' => 'services_category',
                'description' => __('دسته‌هایی را که نمی‌خواهید نمایش داده شوند انتخاب کنید', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'include',
            [
                'label' => __('نمایش فقط دسته‌های انتخاب شده', 'mohtavanegar'),
                'type' => 'mohtavanegar-query',
                'post_type' => '',
                'options' => [],
                'label_block' => true,
                'multiple' => true,
                'query_type' => 'terms',
                'taxonomy' => 'services_category',
                'description' => __('در صورت انتخاب، فقط دسته‌های انتخاب شده نمایش داده می‌شوند', 'mohtavanegar'),
            ]
        );
        
        $this->add_responsive_control(
            'item_height',
            [
                'label' => __('ارتفاع آیتم (پیکسل)', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                        'step' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'title_alignment',
            [
                'label' => __('تراز متن عنوان', 'mohtavanegar'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .service-title' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'description_alignment',
            [
                'label' => __('تراز متن توضیحات', 'mohtavanegar'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'justify' => [
                        'title' => __('تراز شده', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .service-description' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('تعداد ستون‌ها', 'mohtavanegar'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .services-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
            ]
        );

        $this->add_control(
            'show_image',
            [
                'label' => __('نمایش تصویر', 'mohtavanegar'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Overlay Style
        $this->start_controls_section(
            'overlay_style_section',
            [
                'label' => __('روکش آیتم‌ها', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('overlay_style_tabs');

        $this->start_controls_tab(
            'overlay_normal_tab',
            ['label' => __('عادی', 'mohtavanegar')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_background',
                'label' => __('پس‌زمینه روکش', 'mohtavanegar'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-overlay',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'color' => [
                        'default' => 'rgba(0, 0, 0, 0.9)',
                    ],
                ],
            ]
        );

        $this->add_control(
            'overlay_opacity',
            [
                'label' => __('شفافیت', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 0.9,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-overlay' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'overlay_hover_tab',
            ['label' => __('هاور', 'mohtavanegar')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_hover_background',
                'label' => __('پس‌زمینه در حالت هاور', 'mohtavanegar'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-item:hover .service-overlay',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'color' => [
                        'default' => 'rgba(0, 0, 0, 0.95)',
                    ],
                ],
            ]
        );

        $this->add_control(
            'overlay_hover_opacity',
            [
                'label' => __('شفافیت در حالت هاور', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 0.95,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item:hover .service-overlay' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'overlay_transition_duration',
            [
                'label' => __('مدت زمان انیمیشن (ثانیه)', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 3,
                        'min' => 0.1,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-overlay' => 'transition: all {{SIZE}}s ease;',
                ],
                'separator' => 'before',
            ]
        );

        // Hover Animation
        $this->add_control(
            'hover_animation_heading',
            [
                'label' => __('انیمیشن هاور', 'mohtavanegar'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_scale',
            [
                'label' => __('مقیاس در حالت هاور', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1.2,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 1.03,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item:hover' => 'transform: translateY(-8px) scale({{SIZE}});',
                ],
            ]
        );

        $this->add_control(
            'hover_animation_duration',
            [
                'label' => __('مدت زمان انیمیشن (ثانیه)', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item' => 'transition: all {{SIZE}}s cubic-bezier(0.25, 0.8, 0.25, 1);',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'grid_gap',
            [
                'label' => __('فاصله بین آیتم‌ها', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .services-grid' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .service-item',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .service-item',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('حاشیه گرد', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('فاصله داخلی', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title Style
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('عنوان', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ متن عنوان', 'mohtavanegar'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .service-title, {{WRAPPER}} .service-title a' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        
        $this->add_control(
            'title_hover_color',
            [
                'label' => __('رنگ متن عنوان هاور', 'mohtavanegar'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .service-title a:hover' => 'color: {{VALUE}} !important;',
                ],
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .service-title',
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __('فاصله از بالا', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-title' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Description Style
        $this->start_controls_section(
            'description_style_section',
            [
                'label' => __('توضیحات', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('رنگ متن', 'mohtavanegar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .service-description',
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __('فاصله از عنوان', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-description' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Subtitle Style
        $this->start_controls_section(
            'subtitle_style_section',
            [
                'label' => __('زیرعنوان', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('رنگ متن', 'mohtavanegar'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(255, 255, 255, 0.9)',
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .service-subtitle',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 14,
                        ],
                    ],
                    'font_weight' => [
                        'default' => '400',
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'em',
                            'size' => 1.5,
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'subtitle_alignment',
            [
                'label' => __('تراز متن', 'mohtavanegar'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_spacing',
            [
                'label' => __('فاصله از عنوان', 'mohtavanegar'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_padding',
            [
                'label' => __('فاصله داخلی', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_bg_color',
            [
                'label' => __('رنگ پس‌زمینه', 'mohtavanegar'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'background-color: {{VALUE}}',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'subtitle_border_radius',
            [
                'label' => __('حاشیه گرد', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-subtitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $args = [
            'taxonomy' => 'services_category',
            'hide_empty' => $settings['hide_empty'] === 'yes',
            'number' => $settings['number'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
        ];

        // Handle include/exclude categories
        if (!empty($settings['include'])) {
            $args['include'] = $settings['include'];
            $args['orderby'] = 'include';
        } elseif (!empty($settings['exclude'])) {
            $args['exclude'] = $settings['exclude'];
        }

        // If order by display_order is selected
        if ($settings['orderby'] === 'meta_value_num') {
    $args['meta_key'] = 'display_order';
    $args['meta_query'] = [
        'relation' => 'OR',
        [
            'key' => 'display_order',
            'compare' => 'NOT EXISTS',
        ],
        [
            'key' => 'display_order',
            'compare' => '>',
            'value' => 0,
            'type' => 'NUMERIC'
        ]
    ];
}

        $categories = get_terms($args);

        if (is_wp_error($categories) || empty($categories)) {
            echo '<p>' . __('هیچ دسته‌بندی سرویسی یافت نشد.', 'mohtavanegar') . '</p>';
            return;
        }
        ?>
        <div class="services-grid">
            <?php foreach ($categories as $category) : 
                $background_image_id = get_term_meta($category->term_id, 'taxonomy_background_image', true);
                $category_bg_color = get_term_meta($category->term_id, 'background_color', true);
                $category_url = get_term_link($category);
                
                // Get background image URL if available
                $background_style = '';
                if ($settings['show_image'] === 'yes' && !empty($background_image_id)) {
                    $background_image_url = wp_get_attachment_image_url($background_image_id, 'large');
                    if ($background_image_url) {
                        $background_style = 'style="background-image: url(' . esc_url($background_image_url) . '); background-position: center;"';
                    }
                }
                ?>
                <a href="<?php echo esc_url($category_url); ?>" class="service-item-link">
                    <div class="service-item" <?php echo $background_style . ($category_bg_color ? '; background-color: ' . esc_attr($category_bg_color) : ''); ?>>
                        <div class="service-overlay"></div>
                        
                        <div class="service-content">
                            <h3 class="service-title">
                                <?php echo esc_html($category->name); ?>
                                <?php if ($settings['show_count'] === 'yes') : ?>
                                    <span class="service-count">(<?php echo esc_html($category->count); ?>)</span>
                                <?php endif; ?>
                            </h3>
                        
                        <?php 
                        // Display subtitle if enabled
                        if ($settings['show_subtitle'] === 'yes') : 
                            $subtitle = get_term_meta($category->term_id, 'taxonomy_subtitle', true);
                            if (!empty($subtitle)) : 
                        ?>
                            <div class="service-subtitle"><?php echo esc_html($subtitle); ?></div>
                        <?php 
                            endif;
                        endif; 
                        ?>
                        
                        <?php if ($settings['show_description'] === 'yes' && !empty($category->description)) : 
                            $description = $category->description;
                            
                            // Process description if length is set
                            if (!empty($settings['description_length']) && $settings['description_length'] > 0) {
                                $description = wp_strip_all_tags($description);
                                $description = mb_substr($description, 0, $settings['description_length'], 'UTF-8');
                                
                                // Add ellipsis if text was truncated
                                if (mb_strlen($category->description, 'UTF-8') > $settings['description_length']) {
                                    $description .= isset($settings['description_after_text']) ? $settings['description_after_text'] : '...';
                                }
                                
                                // Convert line breaks to <br> tags
                                $description = nl2br($description);
                            }
                            
                            // Allow only safe HTML tags
                            $allowed_html = [
                                'a' => [
                                    'href' => [],
                                    'title' => [],
                                    'target' => [],
                                    'rel' => [],
                                ],
                                'br' => [],
                                'em' => [],
                                'strong' => [],
                                'p' => [
                                    'class' => [],
                                    'style' => [],
                                ],
                                'span' => [
                                    'class' => [],
                                    'style' => [],
                                ],
                                'ul' => [
                                    'class' => [],
                                ],
                                'ol' => [
                                    'class' => [],
                                ],
                                'li' => [
                                    'class' => [],
                                ],
                            ];
                            ?>
                            <div class="service-description"><?php echo wp_kses($description, $allowed_html); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                </a>
            <?php endforeach; ?>
        </div>
        <?php
    }
}
