<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Services_List_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'mohtavanegar_services_list';
    }

    public function get_title() {
        return esc_html__('لیست خدمات', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_keywords() {
        return ['services', 'list', 'mohtavanegar'];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات محتوا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('تعداد خدمات در هر صفحه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 6,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .services-grid' => '--columns: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_services_categories(),
                'multiple' => true,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب‌سازی بر اساس', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('تاریخ', 'mohtavanegar'),
                    'title' => esc_html__('عنوان', 'mohtavanegar'),
                    'menu_order' => esc_html__('ترتیب منو', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => esc_html__('صعودی', 'mohtavanegar'),
                    'DESC' => esc_html__('نزولی', 'mohtavanegar'),
                ],
            ]
        );

        $this->end_controls_section(); // End content_section

        // Image Section
        $this->start_controls_section(
            'image_section',
            [
                'label' => esc_html__('تنظیمات تصویر', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_image',
            [
                'label' => esc_html__('نمایش تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => esc_html__('اندازه تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'medium',
                'options' => [
                    'thumbnail' => esc_html__('کوچک (150x150)', 'mohtavanegar'),
                    'medium' => esc_html__('متوسط (300x300)', 'mohtavanegar'),
                    'medium_large' => esc_html__('متوسط بزرگ (768x0)', 'mohtavanegar'),
                    'large' => esc_html__('بزرگ (1024x1024)', 'mohtavanegar'),
                    'full' => esc_html__('کامل', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_image' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label' => esc_html__('موقعیت تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'top',
                'options' => [
                    'top' => esc_html__('بالا', 'mohtavanegar'),
                    'left' => esc_html__('چپ', 'mohtavanegar'),
                    'right' => esc_html__('راست', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_image' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Icon Section
        $this->start_controls_section(
            'icon_section',
            [
                'label' => esc_html__('تنظیمات آیکون', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__('نمایش آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label' => esc_html__('موقعیت آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'top',
                'options' => [
                    'top' => esc_html__('بالا', 'mohtavanegar'),
                    'left' => esc_html__('چپ', 'mohtavanegar'),
                    'right' => esc_html__('راست', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Excerpt Section
        $this->start_controls_section(
            'excerpt_section',
            [
                'label' => esc_html__('تنظیمات توضیحات', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('نمایش توضیحات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_source',
            [
                'label' => esc_html__('منبع توضیحات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'excerpt',
                'options' => [
                    'excerpt' => esc_html__('چکیده مطلب', 'mohtavanegar'),
                    'content' => esc_html__('محتوای کامل', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('تعداد کلمات توضیحات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
                'min' => 5,
                'max' => 200,
                'step' => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'excerpt_more',
            [
                'label' => esc_html__('متن ادامه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '...',
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Button Section
        $this->start_controls_section(
            'button_section',
            [
                'label' => esc_html__('تنظیمات دکمه', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_details_button',
            [
                'label' => esc_html__('نمایش دکمه جزئیات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'details_button_text',
            [
                'label' => esc_html__('متن دکمه جزئیات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده جزئیات', 'mohtavanegar'),
                'condition' => [
                    'show_details_button' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Display Options Section
        $this->start_controls_section(
            'display_options_section',
            [
                'label' => esc_html__('تنظیمات نمایش', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_meta',
            [
                'label' => esc_html__('نمایش متا اطلاعات (قیمت و زمان)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'mohtavanegar'),
                'label_off' => esc_html__('پنهان', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Image Style Section
        $this->start_controls_section(
            'image_style_section',
            [
                'label' => esc_html__('استایل تصویر', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_image' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_width',
            [
                'label' => esc_html__('عرض تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-thumbnail' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .service-item.image-left .service-thumbnail' => 'width: {{SIZE}}{{UNIT}}; flex: 0 0 {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .service-item.image-right .service-thumbnail' => 'width: {{SIZE}}{{UNIT}}; flex: 0 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__('ارتفاع تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 600,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 80,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-thumbnail' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'image_position' => ['left', 'right'],
                ],
            ]
        );

        $this->add_control(
            'image_object_fit',
            [
                'label' => esc_html__('برازش تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'cover' => esc_html__('پوشاندن', 'mohtavanegar'),
                    'contain' => esc_html__('شامل شدن', 'mohtavanegar'),
                    'fill' => esc_html__('پر کردن', 'mohtavanegar'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-image' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_padding',
            [
                'label' => esc_html__('فاصله داخلی تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_margin',
            [
                'label' => esc_html__('فاصله خارجی تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-thumbnail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_align',
            [
                'label' => esc_html__('تراز تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .service-thumbnail' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'label' => esc_html__('حاشیه تصویر', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-image',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .service-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'label' => esc_html__('سایه تصویر', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-image',
            ]
        );

        $this->end_controls_section();

        // Icon Style Section
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('استایل آیکون', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('اندازه آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4CAF50',
                'selectors' => [
                    '{{WRAPPER}} .service-icon i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('فاصله داخلی آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_margin',
            [
                'label' => esc_html__('فاصله خارجی آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .service-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_align',
            [
                'label' => esc_html__('تراز آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .service-icon' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'label' => esc_html__('حاشیه آیکون', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-icon',
            ]
        );

        $this->add_responsive_control(
            'icon_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow',
                'label' => esc_html__('سایه آیکون', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-icon',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('تنظیمات ظاهری', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'title_align',
            [
                'label' => esc_html__('تراز متن عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .service-title' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-title',
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('رنگ قیمت', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'label' => esc_html__('تایپوگرافی قیمت', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .service-price',
            ]
        );

        $this->end_controls_section();

        // Hover Style Section
        $this->start_controls_section(
            'hover_style_section',
            [
                'label' => esc_html__('استایل هاور', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'hover_background',
            [
                'label' => esc_html__('رنگ پس زمینه هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ عنوان در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-item:hover .service-title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ آیکون در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-item:hover .service-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        // Grid Style Section
        $this->start_controls_section(
            'grid_style_section',
            [
                'label' => esc_html__('تنظیمات شبکه‌ای', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label' => esc_html__('فاصله بین ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .services-grid' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label' => esc_html__('فاصله بین ردیف‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .services-grid' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $args = array(
            'post_type' => 'services',
            'posts_per_page' => $settings['posts_per_page'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
        );

        if (!empty($settings['category'])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'services_category',
                    'field' => 'term_id',
                    'terms' => $settings['category'],
                ),
            );
        }

        $services = new \WP_Query($args);

        if ($services->have_posts()) :
            $this->add_render_attribute('grid', 'class', 'services-grid');
            $this->add_render_attribute('grid', 'class', 'elementor-grid');
            
            // Responsive columns via inline CSS
            $columns = $settings['columns'] ?? '3';
            $columns_tablet = $settings['columns_tablet'] ?? '2';
            $columns_mobile = $settings['columns_mobile'] ?? '1';
            
            // Add inline styles for responsive columns
            $this->add_render_attribute('grid', 'data-columns', $columns);
            $this->add_render_attribute('grid', 'data-columns-tablet', $columns_tablet);
            $this->add_render_attribute('grid', 'data-columns-mobile', $columns_mobile);
            
            echo '<div ' . $this->get_render_attribute_string('grid') . '>';
            
            while ($services->have_posts()) : $services->the_post();
                $price = get_post_meta(get_the_ID(), '_service_price', true);
                $duration = get_post_meta(get_the_ID(), '_service_duration', true);
                $icon = get_post_meta(get_the_ID(), '_service_icon', true);
                
                // Get settings
                $show_image = $settings['show_image'] ?? 'yes';
                $show_icon = $settings['show_icon'] ?? 'yes';
                $image_position = $settings['image_position'] ?? 'top';
                $icon_position = $settings['icon_position'] ?? 'top';
                $image_size = $settings['image_size'] ?? 'medium';
                
                // Add classes based on layout
                $item_classes = ['service-item'];
                if ($show_image === 'yes' && has_post_thumbnail()) {
                    $item_classes[] = 'image-' . $image_position;
                }
                if ($show_icon === 'yes' && $icon) {
                    $item_classes[] = 'icon-' . $icon_position;
                }
                ?>
                <div class="<?php echo esc_attr(implode(' ', $item_classes)); ?>">
                    <div class="service-item-inner">
                        <?php if ($show_image === 'yes' && has_post_thumbnail()) : ?>
                            <div class="service-thumbnail">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail($image_size, ['class' => 'service-image']); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <div class="service-content">
                            <?php if ($show_icon === 'yes' && $icon) : ?>
                                <div class="service-icon">
                                    <i class="<?php echo esc_attr($icon); ?>"></i>
                                </div>
                            <?php endif; ?>
                            
                            <h3 class="service-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            
                            <?php 
                            $show_excerpt = isset($settings['show_excerpt']) ? $settings['show_excerpt'] : 'yes';
                            $excerpt_length = isset($settings['excerpt_length']) ? absint($settings['excerpt_length']) : 15;
                            $excerpt_text = get_the_excerpt();
                            
                            if ($show_excerpt === 'yes' && !empty($excerpt_text)) : ?>
                                <div class="service-excerpt">
                                    <?php 
                                    if ($settings['excerpt_source'] === 'content') {
                                        $content = get_the_content();
                                        $content = strip_shortcodes($content);
                                        $content = wp_strip_all_tags($content);
                                        echo wp_trim_words($content, $excerpt_length, $settings['excerpt_more']);
                                    } else {
                                        echo wp_trim_words($excerpt_text, $excerpt_length, $settings['excerpt_more']);
                                    }
                                    ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($settings['show_meta'] === 'yes' && ($price || $duration)) : ?>
                                <div class="service-meta">
                                    <?php if ($price) : ?>
                                        <span class="service-price">
                                            <i class="fas fa-tag"></i> 
                                            <?php echo esc_html($price); ?>
                                        </span>
                                    <?php endif; ?>
                                    
                                    <?php if ($duration) : ?>
                                        <span class="service-duration">
                                            <i class="far fa-clock"></i> 
                                            <?php echo esc_html($duration); ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($settings['show_details_button'] === 'yes') : ?>
                                <a href="<?php the_permalink(); ?>" class="service-read-more">
                                    <?php echo esc_html($settings['details_button_text']); ?>
                                    <i class="fas fa-arrow-left"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
            
            echo '</div>';
            
            // Add enhanced CSS with responsive grid and advanced styling
            $desktop_columns = isset($settings['columns']) ? intval($settings['columns']) : 3;
            $tablet_columns = isset($settings['columns_tablet']) ? intval($settings['columns_tablet']) : 2;
            $mobile_columns = isset($settings['columns_mobile']) ? intval($settings['columns_mobile']) : 1;
            
            // Generate CSS with proper escaping
            ?>
            <style>
                .services-grid {
                    display: grid;
                    grid-template-columns: repeat(<?php echo $desktop_columns; ?>, 1fr);
                    gap: 20px;
                    margin: auto !important;
                }
                
                @media (max-width: 1024px) {
                    .services-grid[data-columns-tablet] {
                        grid-template-columns: repeat(<?php echo $tablet_columns; ?>, 1fr) !important;
                    }
                }
                
                @media (max-width: 767px) {
                    .services-grid[data-columns-mobile] {
                        grid-template-columns: repeat(<?php echo $mobile_columns; ?>, 1fr) !important;
                    }
                }
                
                /* Base service item styling */
                .service-item {
                    background: #fff;
                    border-radius: 10px;
                    overflow: hidden;
                    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
                    transition: all 0.3s ease;
                    height: 100%;
                    max-width: 100%;
                    box-sizing: border-box;
                }
                
                .service-item:hover {
                    transform: translateY(-5px);
                    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
                }
                
                .service-item-inner {
                    display: flex;
                    flex-direction: column;
                    height: 100%;
                }
                
                /* Image positioning layouts */
                .service-item.image-left .service-item-inner,
                .service-item.image-right .service-item-inner {
                    flex-direction: row;
                    align-items: stretch;
                }
                
                .service-item.image-right .service-item-inner {
                    flex-direction: row-reverse;
                }
                
                .service-item.image-left .service-content,
                .service-item.image-right .service-content {
                    flex: 1;
                    display: flex;
                    flex-direction: column;
                }
                
                /* Thumbnail styling */
                .service-thumbnail {
                    position: relative;
                    overflow: hidden;
                }
                
                .service-item.image-top .service-thumbnail {
                    padding-top: 60%;
                }
                
                .service-item.image-left .service-thumbnail,
                .service-item.image-right .service-thumbnail {
                    min-height: 200px;
                }
                
                .service-thumbnail img {
                    width: 100%;
                    height: 100%;
                    transition: transform 0.5s ease;
                }
                
                .service-item.image-top .service-thumbnail img {
                    position: absolute;
                    top: 0;
                    right: 0;
                    object-fit: cover;
                }
                
                .service-item:hover .service-thumbnail img {
                    transform: scale(1.05);
                }
                
                /* Content styling */
                .service-content {
                    padding: 20px;
                    flex: 1;
                    display: flex;
                    flex-direction: column;
                }
                
                /* Icon styling with positioning */
                .service-icon {
                    font-size: 30px;
                    color: #4CAF50;
                    margin-bottom: 15px;
                    display: inline-block;
                }
                
                .service-item.icon-left .service-icon {
                    float: left;
                    margin-left: 15px;
                    margin-bottom: 0;
                }
                
                .service-item.icon-right .service-icon {
                    float: right;
                    margin-right: 15px;
                    margin-bottom: 0;
                }
                
                .service-item.icon-left .service-title,
                .service-item.icon-right .service-title {
                    clear: none;
                    padding-top: 5px;
                }
                
                /* Title styling */
                .service-title {
                    margin: 0 0 10px 0;
                    font-size: 18px;
                    line-height: 1.4;
                    text-align: var(--title-align, right);
                }
                
                .service-title a {
                    color: #333;
                    text-decoration: none;
                    transition: color 0.3s ease;
                }
                
                /* Excerpt styling */
                .service-excerpt {
                    color: #666;
                    font-size: 14px;
                    margin-bottom: 15px;
                    flex-grow: 1;
                    line-height: 1.6;
                }
                
                /* Meta styling */
                .service-meta {
                    display: flex;
                    gap: 15px;
                    margin: 15px 0;
                    font-size: 13px;
                    color: #777;
                    flex-wrap: wrap;
                }
                
                .service-price, .service-duration {
                    display: flex;
                    align-items: center;
                    gap: 5px;
                    white-space: nowrap;
                }
                
                /* Button styling */
                .service-read-more {
                    display: inline-flex;
                    align-items: center;
                    color: #4CAF50;
                    text-decoration: none;
                    font-weight: 500;
                    margin-top: auto;
                    transition: all 0.3s ease;
                    padding: 8px 0;
                }
                
                .service-read-more i {
                    margin-left: 5px;
                    transition: transform 0.3s ease;
                }
                
                .service-read-more:hover {
                    color: #3d8b40;
                }
                
                .service-read-more:hover i {
                    transform: translateX(-5px);
                }
                
                /* Responsive adjustments */
                @media (max-width: 767px) {
                    .service-item.image-left .service-item-inner,
                    .service-item.image-right .service-item-inner {
                        flex-direction: column;
                    }
                    
                    .service-item.image-left .service-thumbnail,
                    .service-item.image-right .service-thumbnail {
                        padding-top: 60%;
                        min-height: auto;
                    }
                    
                    .service-item.image-left .service-thumbnail img,
                    .service-item.image-right .service-thumbnail img {
                        position: absolute;
                        top: 0;
                        right: 0;
                        object-fit: cover;
                    }
                    
                    .service-item.icon-left .service-icon,
                    .service-item.icon-right .service-icon {
                        float: none;
                        margin: 0 0 15px 0;
                    }
                    
                    .service-content {
                        padding: 15px;
                    }
                    
                    .service-meta {
                        flex-direction: column;
                        gap: 8px;
                    }
                }
                
                /* Additional hover effects */
                .service-item:hover .service-icon i {
                    transform: scale(1.1);
                }
                
                /* Clearfix for floating icons */
                .service-content::after {
                    content: "";
                    display: table;
                    clear: both;
                }
            </style>
            <?php
            wp_reset_postdata();
        else :
            echo '<p>' . esc_html__('هیچ خدمتی یافت نشد.', 'mohtavanegar') . '</p>';
        endif;
    }

    private function get_services_categories() {
        $categories = get_terms(array(
            'taxonomy' => 'services_category',
            'hide_empty' => true,
        ));

        $options = array();
        if (!is_wp_error($categories)) {
            foreach ($categories as $category) {
                $options[$category->term_id] = $category->name;
            }
        }

        return $options;
    }
}